%------------------------------------------------------------------------------
% File     : ITP095^2 : TPTP v9.2.0. Released v7.5.0.
% Domain   : Interactive Theorem Proving
% Problem  : Sledgehammer Liouville_Numbers problem prob_189__5867098_1
% Version  : Especial.
% English  :

% Refs     : [BH+15] Blanchette et al. (2015), Mining the Archive of Formal
%          : [Des21] Desharnais (2021), Email to Geoff Sutcliffe
% Source   : [Des21]
% Names    : Liouville_Numbers/prob_189__5867098_1 [Des21]

% Status   : Theorem
% Rating   : 0.00 v7.5.0
% Syntax   : Number of formulae    :  408 (  95 unt;  62 typ;   0 def)
%            Number of atoms       : 1022 ( 287 equ;   0 cnn)
%            Maximal formula atoms :    6 (   2 avg)
%            Number of connectives : 3839 (  43   ~;  21   |;  43   &;3306   @)
%                                         (   0 <=>; 426  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   16 (   6 avg)
%            Number of types       :    4 (   3 usr)
%            Number of type conns  :   30 (  30   >;   0   *;   0   +;   0  <<)
%            Number of symbols     :   60 (  59 usr;   9 con; 0-3 aty)
%            Number of variables   :  761 (  17   ^; 688   !;   8   ?; 761   :)
%                                         (  48  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TH1_THM_EQU_NAR

% Comments : This file was generated by Sledgehammer 2021-02-23 16:25:38.390
%------------------------------------------------------------------------------
% Could-be-implicit typings (5)
thf(ty_t_Polynomial_Opoly,type,
    poly: $tType > $tType ).

thf(ty_t_Real_Oreal,type,
    real: $tType ).

thf(ty_t_Set_Oset,type,
    set: $tType > $tType ).

thf(ty_t_Nat_Onat,type,
    nat: $tType ).

thf(ty_t_Int_Oint,type,
    int: $tType ).

% Explicit typings (57)
thf(sy_cl_Groups_Oab__group__add,type,
    ab_group_add: 
      !>[A: $tType] : $o ).

thf(sy_cl_Rings_Oidom,type,
    idom: 
      !>[A: $tType] : $o ).

thf(sy_cl_Groups_Oone,type,
    one: 
      !>[A: $tType] : $o ).

thf(sy_cl_Groups_Ozero,type,
    zero: 
      !>[A: $tType] : $o ).

thf(sy_cl_Power_Opower,type,
    power: 
      !>[A: $tType] : $o ).

thf(sy_cl_Fields_Ofield,type,
    field: 
      !>[A: $tType] : $o ).

thf(sy_cl_Rings_Oring__1,type,
    ring_1: 
      !>[A: $tType] : $o ).

thf(sy_cl_Nat_Oring__char__0,type,
    ring_char_0: 
      !>[A: $tType] : $o ).

thf(sy_cl_Rings_Ocomm__ring,type,
    comm_ring: 
      !>[A: $tType] : $o ).

thf(sy_cl_Groups_Ogroup__add,type,
    group_add: 
      !>[A: $tType] : $o ).

thf(sy_cl_Rings_Osemiring__1,type,
    semiring_1: 
      !>[A: $tType] : $o ).

thf(sy_cl_Rings_Ocomm__ring__1,type,
    comm_ring_1: 
      !>[A: $tType] : $o ).

thf(sy_cl_Rings_Oidom__divide,type,
    idom_divide: 
      !>[A: $tType] : $o ).

thf(sy_cl_Groups_Omonoid__mult,type,
    monoid_mult: 
      !>[A: $tType] : $o ).

thf(sy_cl_Fields_Ofield__char__0,type,
    field_char_0: 
      !>[A: $tType] : $o ).

thf(sy_cl_Fields_Odivision__ring,type,
    division_ring: 
      !>[A: $tType] : $o ).

thf(sy_cl_Fields_Ofield__abs__sgn,type,
    field_abs_sgn: 
      !>[A: $tType] : $o ).

thf(sy_cl_Rings_Ocomm__semiring__0,type,
    comm_semiring_0: 
      !>[A: $tType] : $o ).

thf(sy_cl_Rings_Ocomm__semiring__1,type,
    comm_semiring_1: 
      !>[A: $tType] : $o ).

thf(sy_cl_Rings_Olinordered__idom,type,
    linordered_idom: 
      !>[A: $tType] : $o ).

thf(sy_cl_Fields_Olinordered__field,type,
    linordered_field: 
      !>[A: $tType] : $o ).

thf(sy_cl_Groups_Ocomm__monoid__diff,type,
    comm_monoid_diff: 
      !>[A: $tType] : $o ).

thf(sy_cl_Rings_Olinordered__semidom,type,
    linordered_semidom: 
      !>[A: $tType] : $o ).

thf(sy_cl_Groups_Oordered__ab__group__add,type,
    ordered_ab_group_add: 
      !>[A: $tType] : $o ).

thf(sy_cl_Rings_Oring__no__zero__divisors,type,
    ring_n68954251visors: 
      !>[A: $tType] : $o ).

thf(sy_cl_Groups_Ocancel__comm__monoid__add,type,
    cancel1352612707id_add: 
      !>[A: $tType] : $o ).

thf(sy_cl_Groups_Ocancel__ab__semigroup__add,type,
    cancel146912293up_add: 
      !>[A: $tType] : $o ).

thf(sy_cl_Groups_Oordered__ab__group__add__abs,type,
    ordere142940540dd_abs: 
      !>[A: $tType] : $o ).

thf(sy_cl_Rings_Osemiring__no__zero__divisors,type,
    semiri1193490041visors: 
      !>[A: $tType] : $o ).

thf(sy_cl_Rings_Osemiring__1__no__zero__divisors,type,
    semiri134348788visors: 
      !>[A: $tType] : $o ).

thf(sy_cl_Groups_Ocanonically__ordered__monoid__add,type,
    canoni770627133id_add: 
      !>[A: $tType] : $o ).

thf(sy_c_Groups_Oabs__class_Oabs,type,
    abs_abs: 
      !>[A: $tType] : ( A > A ) ).

thf(sy_c_Groups_Ominus__class_Ominus,type,
    minus_minus: 
      !>[A: $tType] : ( A > A > A ) ).

thf(sy_c_Groups_Oone__class_Oone,type,
    one_one: 
      !>[A: $tType] : A ).

thf(sy_c_Groups_Ozero__class_Ozero,type,
    zero_zero: 
      !>[A: $tType] : A ).

thf(sy_c_Int_Oring__1__class_OInts,type,
    ring_1_Ints: 
      !>[A: $tType] : ( set @ A ) ).

thf(sy_c_Int_Oring__1__class_Oof__int,type,
    ring_1_of_int: 
      !>[A: $tType] : ( int > A ) ).

thf(sy_c_Orderings_Oord__class_Oless,type,
    ord_less: 
      !>[A: $tType] : ( A > A > $o ) ).

thf(sy_c_Orderings_Oord__class_Oless__eq,type,
    ord_less_eq: 
      !>[A: $tType] : ( A > A > $o ) ).

thf(sy_c_Polynomial_Oalgebraic,type,
    algebraic: 
      !>[A: $tType] : ( A > $o ) ).

thf(sy_c_Polynomial_Odegree,type,
    degree: 
      !>[A: $tType] : ( ( poly @ A ) > nat ) ).

thf(sy_c_Polynomial_Opoly,type,
    poly2: 
      !>[A: $tType] : ( ( poly @ A ) > A > A ) ).

thf(sy_c_Polynomial_Opoly_Ocoeff,type,
    coeff: 
      !>[A: $tType] : ( ( poly @ A ) > nat > A ) ).

thf(sy_c_Power_Opower__class_Opower,type,
    power_power: 
      !>[A: $tType] : ( A > nat > A ) ).

thf(sy_c_Rat_Ofield__char__0__class_ORats,type,
    field_char_0_Rats: 
      !>[A: $tType] : ( set @ A ) ).

thf(sy_c_Rings_Odivide__class_Odivide,type,
    divide_divide: 
      !>[A: $tType] : ( A > A > A ) ).

thf(sy_c_Set_OCollect,type,
    collect: 
      !>[A: $tType] : ( ( A > $o ) > ( set @ A ) ) ).

thf(sy_c_member,type,
    member: 
      !>[A: $tType] : ( A > ( set @ A ) > $o ) ).

thf(sy_v_A____,type,
    a: real ).

thf(sy_v_M____,type,
    m: real ).

thf(sy_v_a____,type,
    a2: int ).

thf(sy_v_b____,type,
    b: int ).

thf(sy_v_n____,type,
    n: nat ).

thf(sy_v_p____,type,
    p: poly @ real ).

thf(sy_v_roots____,type,
    roots: set @ real ).

thf(sy_v_thesis,type,
    thesis: $o ).

thf(sy_v_x,type,
    x: real ).

% Relevant facts (254)
thf(fact_0_assms_I2_J,axiom,
    algebraic @ real @ x ).

% assms(2)
thf(fact_1_p_I2_J,axiom,
    ( p
   != ( zero_zero @ ( poly @ real ) ) ) ).

% p(2)
thf(fact_2_p_I1_J,axiom,
    ! [I: nat] : ( member @ real @ ( coeff @ real @ p @ I ) @ ( ring_1_Ints @ real ) ) ).

% p(1)
thf(fact_3_b,axiom,
    ord_less @ int @ ( zero_zero @ int ) @ b ).

% b
thf(fact_4_p_I3_J,axiom,
    ( ( poly2 @ real @ p @ x )
    = ( zero_zero @ real ) ) ).

% p(3)
thf(fact_5_no__root,axiom,
    ( ( poly2 @ real @ p @ ( divide_divide @ real @ ( ring_1_of_int @ real @ a2 ) @ ( ring_1_of_int @ real @ b ) ) )
   != ( zero_zero @ real ) ) ).

% no_root
thf(fact_6_n__def,axiom,
    ( n
    = ( degree @ real @ p ) ) ).

% n_def
thf(fact_7_of__int__le__of__int__power__cancel__iff,axiom,
    ! [A: $tType] :
      ( ( linordered_idom @ A )
     => ! [B: int,W: nat,X: int] :
          ( ( ord_less_eq @ A @ ( power_power @ A @ ( ring_1_of_int @ A @ B ) @ W ) @ ( ring_1_of_int @ A @ X ) )
          = ( ord_less_eq @ int @ ( power_power @ int @ B @ W ) @ X ) ) ) ).

% of_int_le_of_int_power_cancel_iff
thf(fact_8_of__int__power__le__of__int__cancel__iff,axiom,
    ! [A: $tType] :
      ( ( linordered_idom @ A )
     => ! [X: int,B: int,W: nat] :
          ( ( ord_less_eq @ A @ ( ring_1_of_int @ A @ X ) @ ( power_power @ A @ ( ring_1_of_int @ A @ B ) @ W ) )
          = ( ord_less_eq @ int @ X @ ( power_power @ int @ B @ W ) ) ) ) ).

% of_int_power_le_of_int_cancel_iff
thf(fact_9_of__int__1__le__iff,axiom,
    ! [A: $tType] :
      ( ( linordered_idom @ A )
     => ! [Z: int] :
          ( ( ord_less_eq @ A @ ( one_one @ A ) @ ( ring_1_of_int @ A @ Z ) )
          = ( ord_less_eq @ int @ ( one_one @ int ) @ Z ) ) ) ).

% of_int_1_le_iff
thf(fact_10_of__int__le__1__iff,axiom,
    ! [A: $tType] :
      ( ( linordered_idom @ A )
     => ! [Z: int] :
          ( ( ord_less_eq @ A @ ( ring_1_of_int @ A @ Z ) @ ( one_one @ A ) )
          = ( ord_less_eq @ int @ Z @ ( one_one @ int ) ) ) ) ).

% of_int_le_1_iff
thf(fact_11_poly__power,axiom,
    ! [A: $tType] :
      ( ( comm_semiring_1 @ A )
     => ! [P: poly @ A,N: nat,X: A] :
          ( ( poly2 @ A @ ( power_power @ ( poly @ A ) @ P @ N ) @ X )
          = ( power_power @ A @ ( poly2 @ A @ P @ X ) @ N ) ) ) ).

% poly_power
thf(fact_12_poly__1,axiom,
    ! [A: $tType] :
      ( ( comm_semiring_1 @ A )
     => ! [X: A] :
          ( ( poly2 @ A @ ( one_one @ ( poly @ A ) ) @ X )
          = ( one_one @ A ) ) ) ).

% poly_1
thf(fact_13_of__int__abs,axiom,
    ! [A: $tType] :
      ( ( linordered_idom @ A )
     => ! [X: int] :
          ( ( ring_1_of_int @ A @ ( abs_abs @ int @ X ) )
          = ( abs_abs @ A @ ( ring_1_of_int @ A @ X ) ) ) ) ).

% of_int_abs
thf(fact_14_of__int__power,axiom,
    ! [A: $tType] :
      ( ( ring_1 @ A )
     => ! [Z: int,N: nat] :
          ( ( ring_1_of_int @ A @ ( power_power @ int @ Z @ N ) )
          = ( power_power @ A @ ( ring_1_of_int @ A @ Z ) @ N ) ) ) ).

% of_int_power
thf(fact_15_of__int__eq__of__int__power__cancel__iff,axiom,
    ! [A: $tType] :
      ( ( ring_char_0 @ A )
     => ! [B: int,W: nat,X: int] :
          ( ( ( power_power @ A @ ( ring_1_of_int @ A @ B ) @ W )
            = ( ring_1_of_int @ A @ X ) )
          = ( ( power_power @ int @ B @ W )
            = X ) ) ) ).

% of_int_eq_of_int_power_cancel_iff
thf(fact_16_of__int__power__eq__of__int__cancel__iff,axiom,
    ! [A: $tType] :
      ( ( ring_char_0 @ A )
     => ! [X: int,B: int,W: nat] :
          ( ( ( ring_1_of_int @ A @ X )
            = ( power_power @ A @ ( ring_1_of_int @ A @ B ) @ W ) )
          = ( X
            = ( power_power @ int @ B @ W ) ) ) ) ).

% of_int_power_eq_of_int_cancel_iff
thf(fact_17_of__int__1,axiom,
    ! [A: $tType] :
      ( ( ring_1 @ A )
     => ( ( ring_1_of_int @ A @ ( one_one @ int ) )
        = ( one_one @ A ) ) ) ).

% of_int_1
thf(fact_18_of__int__eq__1__iff,axiom,
    ! [A: $tType] :
      ( ( ring_char_0 @ A )
     => ! [Z: int] :
          ( ( ( ring_1_of_int @ A @ Z )
            = ( one_one @ A ) )
          = ( Z
            = ( one_one @ int ) ) ) ) ).

% of_int_eq_1_iff
thf(fact_19_irrationsl,axiom,
    ~ ( member @ real @ x @ ( field_char_0_Rats @ real ) ) ).

% irrationsl
thf(fact_20_of__int__eq__iff,axiom,
    ! [A: $tType] :
      ( ( ring_char_0 @ A )
     => ! [W: int,Z: int] :
          ( ( ( ring_1_of_int @ A @ W )
            = ( ring_1_of_int @ A @ Z ) )
          = ( W = Z ) ) ) ).

% of_int_eq_iff
thf(fact_21__092_060open_062_092_060And_062thesisa_O_A_I_092_060And_062p_O_A_092_060lbrakk_062_092_060And_062i_O_Acoeff_Ap_Ai_A_092_060in_062_A_092_060int_062_059_Ap_A_092_060noteq_062_A0_059_Apoly_Ap_Ax_A_061_A0_092_060rbrakk_062_A_092_060Longrightarrow_062_Athesisa_J_A_092_060Longrightarrow_062_Athesisa_092_060close_062,axiom,
    ~ ! [P2: poly @ real] :
        ( ! [I2: nat] : ( member @ real @ ( coeff @ real @ P2 @ I2 ) @ ( ring_1_Ints @ real ) )
       => ( ( P2
           != ( zero_zero @ ( poly @ real ) ) )
         => ( ( poly2 @ real @ P2 @ x )
           != ( zero_zero @ real ) ) ) ) ).

% \<open>\<And>thesisa. (\<And>p. \<lbrakk>\<And>i. coeff p i \<in> \<int>; p \<noteq> 0; poly p x = 0\<rbrakk> \<Longrightarrow> thesisa) \<Longrightarrow> thesisa\<close>
thf(fact_22__092_060open_062x_A_092_060notin_062_Aroots_092_060close_062,axiom,
    ~ ( member @ real @ x @ roots ) ).

% \<open>x \<notin> roots\<close>
thf(fact_23_of__int__eq__0__iff,axiom,
    ! [A: $tType] :
      ( ( ring_char_0 @ A )
     => ! [Z: int] :
          ( ( ( ring_1_of_int @ A @ Z )
            = ( zero_zero @ A ) )
          = ( Z
            = ( zero_zero @ int ) ) ) ) ).

% of_int_eq_0_iff
thf(fact_24_of__int__0__eq__iff,axiom,
    ! [A: $tType] :
      ( ( ring_char_0 @ A )
     => ! [Z: int] :
          ( ( ( zero_zero @ A )
            = ( ring_1_of_int @ A @ Z ) )
          = ( Z
            = ( zero_zero @ int ) ) ) ) ).

% of_int_0_eq_iff
thf(fact_25_of__int__0,axiom,
    ! [A: $tType] :
      ( ( ring_1 @ A )
     => ( ( ring_1_of_int @ A @ ( zero_zero @ int ) )
        = ( zero_zero @ A ) ) ) ).

% of_int_0
thf(fact_26_of__int__le__iff,axiom,
    ! [A: $tType] :
      ( ( linordered_idom @ A )
     => ! [W: int,Z: int] :
          ( ( ord_less_eq @ A @ ( ring_1_of_int @ A @ W ) @ ( ring_1_of_int @ A @ Z ) )
          = ( ord_less_eq @ int @ W @ Z ) ) ) ).

% of_int_le_iff
thf(fact_27_of__int__less__iff,axiom,
    ! [A: $tType] :
      ( ( linordered_idom @ A )
     => ! [W: int,Z: int] :
          ( ( ord_less @ A @ ( ring_1_of_int @ A @ W ) @ ( ring_1_of_int @ A @ Z ) )
          = ( ord_less @ int @ W @ Z ) ) ) ).

% of_int_less_iff
thf(fact_28_coeff__0,axiom,
    ! [A: $tType] :
      ( ( zero @ A )
     => ! [N: nat] :
          ( ( coeff @ A @ ( zero_zero @ ( poly @ A ) ) @ N )
          = ( zero_zero @ A ) ) ) ).

% coeff_0
thf(fact_29_poly__0,axiom,
    ! [A: $tType] :
      ( ( comm_semiring_0 @ A )
     => ! [X: A] :
          ( ( poly2 @ A @ ( zero_zero @ ( poly @ A ) ) @ X )
          = ( zero_zero @ A ) ) ) ).

% poly_0
thf(fact_30_lead__coeff__of__int,axiom,
    ! [A: $tType] :
      ( ( comm_ring_1 @ A )
     => ! [K: int] :
          ( ( coeff @ A @ ( ring_1_of_int @ ( poly @ A ) @ K ) @ ( degree @ A @ ( ring_1_of_int @ ( poly @ A ) @ K ) ) )
          = ( ring_1_of_int @ A @ K ) ) ) ).

% lead_coeff_of_int
thf(fact_31_leading__coeff__0__iff,axiom,
    ! [A: $tType] :
      ( ( zero @ A )
     => ! [P: poly @ A] :
          ( ( ( coeff @ A @ P @ ( degree @ A @ P ) )
            = ( zero_zero @ A ) )
          = ( P
            = ( zero_zero @ ( poly @ A ) ) ) ) ) ).

% leading_coeff_0_iff
thf(fact_32_zabs__less__one__iff,axiom,
    ! [Z: int] :
      ( ( ord_less @ int @ ( abs_abs @ int @ Z ) @ ( one_one @ int ) )
      = ( Z
        = ( zero_zero @ int ) ) ) ).

% zabs_less_one_iff
thf(fact_33_lead__coeff__1,axiom,
    ! [A: $tType] :
      ( ( comm_semiring_1 @ A )
     => ( ( coeff @ A @ ( one_one @ ( poly @ A ) ) @ ( degree @ A @ ( one_one @ ( poly @ A ) ) ) )
        = ( one_one @ A ) ) ) ).

% lead_coeff_1
thf(fact_34_of__int__le__0__iff,axiom,
    ! [A: $tType] :
      ( ( linordered_idom @ A )
     => ! [Z: int] :
          ( ( ord_less_eq @ A @ ( ring_1_of_int @ A @ Z ) @ ( zero_zero @ A ) )
          = ( ord_less_eq @ int @ Z @ ( zero_zero @ int ) ) ) ) ).

% of_int_le_0_iff
thf(fact_35_of__int__0__le__iff,axiom,
    ! [A: $tType] :
      ( ( linordered_idom @ A )
     => ! [Z: int] :
          ( ( ord_less_eq @ A @ ( zero_zero @ A ) @ ( ring_1_of_int @ A @ Z ) )
          = ( ord_less_eq @ int @ ( zero_zero @ int ) @ Z ) ) ) ).

% of_int_0_le_iff
thf(fact_36_of__int__less__0__iff,axiom,
    ! [A: $tType] :
      ( ( linordered_idom @ A )
     => ! [Z: int] :
          ( ( ord_less @ A @ ( ring_1_of_int @ A @ Z ) @ ( zero_zero @ A ) )
          = ( ord_less @ int @ Z @ ( zero_zero @ int ) ) ) ) ).

% of_int_less_0_iff
thf(fact_37_of__int__0__less__iff,axiom,
    ! [A: $tType] :
      ( ( linordered_idom @ A )
     => ! [Z: int] :
          ( ( ord_less @ A @ ( zero_zero @ A ) @ ( ring_1_of_int @ A @ Z ) )
          = ( ord_less @ int @ ( zero_zero @ int ) @ Z ) ) ) ).

% of_int_0_less_iff
thf(fact_38_of__int__less__1__iff,axiom,
    ! [A: $tType] :
      ( ( linordered_idom @ A )
     => ! [Z: int] :
          ( ( ord_less @ A @ ( ring_1_of_int @ A @ Z ) @ ( one_one @ A ) )
          = ( ord_less @ int @ Z @ ( one_one @ int ) ) ) ) ).

% of_int_less_1_iff
thf(fact_39_of__int__1__less__iff,axiom,
    ! [A: $tType] :
      ( ( linordered_idom @ A )
     => ! [Z: int] :
          ( ( ord_less @ A @ ( one_one @ A ) @ ( ring_1_of_int @ A @ Z ) )
          = ( ord_less @ int @ ( one_one @ int ) @ Z ) ) ) ).

% of_int_1_less_iff
thf(fact_40_of__int__power__less__of__int__cancel__iff,axiom,
    ! [A: $tType] :
      ( ( linordered_idom @ A )
     => ! [X: int,B: int,W: nat] :
          ( ( ord_less @ A @ ( ring_1_of_int @ A @ X ) @ ( power_power @ A @ ( ring_1_of_int @ A @ B ) @ W ) )
          = ( ord_less @ int @ X @ ( power_power @ int @ B @ W ) ) ) ) ).

% of_int_power_less_of_int_cancel_iff
thf(fact_41_of__int__less__of__int__power__cancel__iff,axiom,
    ! [A: $tType] :
      ( ( linordered_idom @ A )
     => ! [B: int,W: nat,X: int] :
          ( ( ord_less @ A @ ( power_power @ A @ ( ring_1_of_int @ A @ B ) @ W ) @ ( ring_1_of_int @ A @ X ) )
          = ( ord_less @ int @ ( power_power @ int @ B @ W ) @ X ) ) ) ).

% of_int_less_of_int_power_cancel_iff
thf(fact_42_less__int__code_I1_J,axiom,
    ~ ( ord_less @ int @ ( zero_zero @ int ) @ ( zero_zero @ int ) ) ).

% less_int_code(1)
thf(fact_43_less__eq__int__code_I1_J,axiom,
    ord_less_eq @ int @ ( zero_zero @ int ) @ ( zero_zero @ int ) ).

% less_eq_int_code(1)
thf(fact_44_poly__eqI,axiom,
    ! [A: $tType] :
      ( ( zero @ A )
     => ! [P: poly @ A,Q: poly @ A] :
          ( ! [N2: nat] :
              ( ( coeff @ A @ P @ N2 )
              = ( coeff @ A @ Q @ N2 ) )
         => ( P = Q ) ) ) ).

% poly_eqI
thf(fact_45_mem__Collect__eq,axiom,
    ! [A: $tType,A2: A,P3: A > $o] :
      ( ( member @ A @ A2 @ ( collect @ A @ P3 ) )
      = ( P3 @ A2 ) ) ).

% mem_Collect_eq
thf(fact_46_Collect__mem__eq,axiom,
    ! [A: $tType,A3: set @ A] :
      ( ( collect @ A
        @ ^ [X2: A] : ( member @ A @ X2 @ A3 ) )
      = A3 ) ).

% Collect_mem_eq
thf(fact_47_Collect__cong,axiom,
    ! [A: $tType,P3: A > $o,Q2: A > $o] :
      ( ! [X3: A] :
          ( ( P3 @ X3 )
          = ( Q2 @ X3 ) )
     => ( ( collect @ A @ P3 )
        = ( collect @ A @ Q2 ) ) ) ).

% Collect_cong
thf(fact_48_ext,axiom,
    ! [B2: $tType,A: $tType,F: A > B2,G: A > B2] :
      ( ! [X3: A] :
          ( ( F @ X3 )
          = ( G @ X3 ) )
     => ( F = G ) ) ).

% ext
thf(fact_49_poly__eq__iff,axiom,
    ! [A: $tType] :
      ( ( zero @ A )
     => ( ( ^ [Y: poly @ A,Z2: poly @ A] : ( Y = Z2 ) )
        = ( ^ [P4: poly @ A,Q3: poly @ A] :
            ! [N3: nat] :
              ( ( coeff @ A @ P4 @ N3 )
              = ( coeff @ A @ Q3 @ N3 ) ) ) ) ) ).

% poly_eq_iff
thf(fact_50_Ints__0,axiom,
    ! [A: $tType] :
      ( ( ring_1 @ A )
     => ( member @ A @ ( zero_zero @ A ) @ ( ring_1_Ints @ A ) ) ) ).

% Ints_0
thf(fact_51_zero__poly_Orep__eq,axiom,
    ! [A: $tType] :
      ( ( zero @ A )
     => ( ( coeff @ A @ ( zero_zero @ ( poly @ A ) ) )
        = ( ^ [Uu: nat] : ( zero_zero @ A ) ) ) ) ).

% zero_poly.rep_eq
thf(fact_52_int__one__le__iff__zero__less,axiom,
    ! [Z: int] :
      ( ( ord_less_eq @ int @ ( one_one @ int ) @ Z )
      = ( ord_less @ int @ ( zero_zero @ int ) @ Z ) ) ).

% int_one_le_iff_zero_less
thf(fact_53_coeff__inject,axiom,
    ! [A: $tType] :
      ( ( zero @ A )
     => ! [X: poly @ A,Y2: poly @ A] :
          ( ( ( coeff @ A @ X )
            = ( coeff @ A @ Y2 ) )
          = ( X = Y2 ) ) ) ).

% coeff_inject
thf(fact_54_le__degree,axiom,
    ! [A: $tType] :
      ( ( zero @ A )
     => ! [P: poly @ A,N: nat] :
          ( ( ( coeff @ A @ P @ N )
           != ( zero_zero @ A ) )
         => ( ord_less_eq @ nat @ N @ ( degree @ A @ P ) ) ) ) ).

% le_degree
thf(fact_55_poly__0__coeff__0,axiom,
    ! [A: $tType] :
      ( ( comm_semiring_0 @ A )
     => ! [P: poly @ A] :
          ( ( poly2 @ A @ P @ ( zero_zero @ A ) )
          = ( coeff @ A @ P @ ( zero_zero @ nat ) ) ) ) ).

% poly_0_coeff_0
thf(fact_56_algebraic__def,axiom,
    ! [A: $tType] :
      ( ( field_char_0 @ A )
     => ( ( algebraic @ A )
        = ( ^ [X2: A] :
            ? [P4: poly @ A] :
              ( ! [I3: nat] : ( member @ A @ ( coeff @ A @ P4 @ I3 ) @ ( ring_1_Ints @ A ) )
              & ( P4
               != ( zero_zero @ ( poly @ A ) ) )
              & ( ( poly2 @ A @ P4 @ X2 )
                = ( zero_zero @ A ) ) ) ) ) ) ).

% algebraic_def
thf(fact_57_algebraicI,axiom,
    ! [A: $tType] :
      ( ( field_char_0 @ A )
     => ! [P: poly @ A,X: A] :
          ( ! [I4: nat] : ( member @ A @ ( coeff @ A @ P @ I4 ) @ ( ring_1_Ints @ A ) )
         => ( ( P
             != ( zero_zero @ ( poly @ A ) ) )
           => ( ( ( poly2 @ A @ P @ X )
                = ( zero_zero @ A ) )
             => ( algebraic @ A @ X ) ) ) ) ) ).

% algebraicI
thf(fact_58_algebraicE,axiom,
    ! [A: $tType] :
      ( ( field_char_0 @ A )
     => ! [X: A] :
          ( ( algebraic @ A @ X )
         => ~ ! [P2: poly @ A] :
                ( ! [I2: nat] : ( member @ A @ ( coeff @ A @ P2 @ I2 ) @ ( ring_1_Ints @ A ) )
               => ( ( P2
                   != ( zero_zero @ ( poly @ A ) ) )
                 => ( ( poly2 @ A @ P2 @ X )
                   != ( zero_zero @ A ) ) ) ) ) ) ).

% algebraicE
thf(fact_59_of__int__pos,axiom,
    ! [A: $tType] :
      ( ( linordered_idom @ A )
     => ! [Z: int] :
          ( ( ord_less @ int @ ( zero_zero @ int ) @ Z )
         => ( ord_less @ A @ ( zero_zero @ A ) @ ( ring_1_of_int @ A @ Z ) ) ) ) ).

% of_int_pos
thf(fact_60_leading__coeff__neq__0,axiom,
    ! [A: $tType] :
      ( ( zero @ A )
     => ! [P: poly @ A] :
          ( ( P
           != ( zero_zero @ ( poly @ A ) ) )
         => ( ( coeff @ A @ P @ ( degree @ A @ P ) )
           != ( zero_zero @ A ) ) ) ) ).

% leading_coeff_neq_0
thf(fact_61_poly__all__0__iff__0,axiom,
    ! [A: $tType] :
      ( ( ( ring_char_0 @ A )
        & ( comm_ring_1 @ A )
        & ( ring_n68954251visors @ A ) )
     => ! [P: poly @ A] :
          ( ( ! [X2: A] :
                ( ( poly2 @ A @ P @ X2 )
                = ( zero_zero @ A ) ) )
          = ( P
            = ( zero_zero @ ( poly @ A ) ) ) ) ) ).

% poly_all_0_iff_0
thf(fact_62_Ints__1,axiom,
    ! [A: $tType] :
      ( ( ring_1 @ A )
     => ( member @ A @ ( one_one @ A ) @ ( ring_1_Ints @ A ) ) ) ).

% Ints_1
thf(fact_63_Ints__power,axiom,
    ! [A: $tType] :
      ( ( ring_1 @ A )
     => ! [A2: A,N: nat] :
          ( ( member @ A @ A2 @ ( ring_1_Ints @ A ) )
         => ( member @ A @ ( power_power @ A @ A2 @ N ) @ ( ring_1_Ints @ A ) ) ) ) ).

% Ints_power
thf(fact_64_Ints__abs,axiom,
    ! [A: $tType] :
      ( ( linordered_idom @ A )
     => ! [A2: A] :
          ( ( member @ A @ A2 @ ( ring_1_Ints @ A ) )
         => ( member @ A @ ( abs_abs @ A @ A2 ) @ ( ring_1_Ints @ A ) ) ) ) ).

% Ints_abs
thf(fact_65_Ints__of__int,axiom,
    ! [A: $tType] :
      ( ( ring_1 @ A )
     => ! [Z: int] : ( member @ A @ ( ring_1_of_int @ A @ Z ) @ ( ring_1_Ints @ A ) ) ) ).

% Ints_of_int
thf(fact_66_Ints__induct,axiom,
    ! [A: $tType] :
      ( ( ring_1 @ A )
     => ! [Q: A,P3: A > $o] :
          ( ( member @ A @ Q @ ( ring_1_Ints @ A ) )
         => ( ! [Z3: int] : ( P3 @ ( ring_1_of_int @ A @ Z3 ) )
           => ( P3 @ Q ) ) ) ) ).

% Ints_induct
thf(fact_67_Ints__cases,axiom,
    ! [A: $tType] :
      ( ( ring_1 @ A )
     => ! [Q: A] :
          ( ( member @ A @ Q @ ( ring_1_Ints @ A ) )
         => ~ ! [Z3: int] :
                ( Q
               != ( ring_1_of_int @ A @ Z3 ) ) ) ) ).

% Ints_cases
thf(fact_68_Ints__nonzero__abs__less1,axiom,
    ! [A: $tType] :
      ( ( linordered_idom @ A )
     => ! [X: A] :
          ( ( member @ A @ X @ ( ring_1_Ints @ A ) )
         => ( ( ord_less @ A @ ( abs_abs @ A @ X ) @ ( one_one @ A ) )
           => ( X
              = ( zero_zero @ A ) ) ) ) ) ).

% Ints_nonzero_abs_less1
thf(fact_69_of__int__nonneg,axiom,
    ! [A: $tType] :
      ( ( linordered_idom @ A )
     => ! [Z: int] :
          ( ( ord_less_eq @ int @ ( zero_zero @ int ) @ Z )
         => ( ord_less_eq @ A @ ( zero_zero @ A ) @ ( ring_1_of_int @ A @ Z ) ) ) ) ).

% of_int_nonneg
thf(fact_70_lead__coeff__power,axiom,
    ! [A: $tType] :
      ( ( ( comm_semiring_1 @ A )
        & ( semiri1193490041visors @ A ) )
     => ! [P: poly @ A,N: nat] :
          ( ( coeff @ A @ ( power_power @ ( poly @ A ) @ P @ N ) @ ( degree @ A @ ( power_power @ ( poly @ A ) @ P @ N ) ) )
          = ( power_power @ A @ ( coeff @ A @ P @ ( degree @ A @ P ) ) @ N ) ) ) ).

% lead_coeff_power
thf(fact_71_Ints__nonzero__abs__ge1,axiom,
    ! [A: $tType] :
      ( ( linordered_idom @ A )
     => ! [X: A] :
          ( ( member @ A @ X @ ( ring_1_Ints @ A ) )
         => ( ( X
             != ( zero_zero @ A ) )
           => ( ord_less_eq @ A @ ( one_one @ A ) @ ( abs_abs @ A @ X ) ) ) ) ) ).

% Ints_nonzero_abs_ge1
thf(fact_72_poly__eq__poly__eq__iff,axiom,
    ! [A: $tType] :
      ( ( ( ring_char_0 @ A )
        & ( comm_ring_1 @ A )
        & ( ring_n68954251visors @ A ) )
     => ! [P: poly @ A,Q: poly @ A] :
          ( ( ( poly2 @ A @ P )
            = ( poly2 @ A @ Q ) )
          = ( P = Q ) ) ) ).

% poly_eq_poly_eq_iff
thf(fact_73_of__int__lessD,axiom,
    ! [A: $tType] :
      ( ( linordered_idom @ A )
     => ! [N: int,X: A] :
          ( ( ord_less @ A @ ( abs_abs @ A @ ( ring_1_of_int @ A @ N ) ) @ X )
         => ( ( N
              = ( zero_zero @ int ) )
            | ( ord_less @ A @ ( one_one @ A ) @ X ) ) ) ) ).

% of_int_lessD
thf(fact_74_of__int__leD,axiom,
    ! [A: $tType] :
      ( ( linordered_idom @ A )
     => ! [N: int,X: A] :
          ( ( ord_less_eq @ A @ ( abs_abs @ A @ ( ring_1_of_int @ A @ N ) ) @ X )
         => ( ( N
              = ( zero_zero @ int ) )
            | ( ord_less_eq @ A @ ( one_one @ A ) @ X ) ) ) ) ).

% of_int_leD
thf(fact_75_int__poly__rat__no__root__ge,axiom,
    ! [P: poly @ real,B: int,A2: int] :
      ( ! [N2: nat] : ( member @ real @ ( coeff @ real @ P @ N2 ) @ ( ring_1_Ints @ real ) )
     => ( ( ord_less @ int @ ( zero_zero @ int ) @ B )
       => ( ( ( poly2 @ real @ P @ ( divide_divide @ real @ ( ring_1_of_int @ real @ A2 ) @ ( ring_1_of_int @ real @ B ) ) )
           != ( zero_zero @ real ) )
         => ( ord_less_eq @ real @ ( divide_divide @ real @ ( one_one @ real ) @ ( power_power @ real @ ( ring_1_of_int @ real @ B ) @ ( degree @ real @ P ) ) ) @ ( abs_abs @ real @ ( poly2 @ real @ P @ ( divide_divide @ real @ ( ring_1_of_int @ real @ A2 ) @ ( ring_1_of_int @ real @ B ) ) ) ) ) ) ) ) ).

% int_poly_rat_no_root_ge
thf(fact_76_power__decreasing__iff,axiom,
    ! [A: $tType] :
      ( ( linordered_semidom @ A )
     => ! [B: A,M: nat,N: nat] :
          ( ( ord_less @ A @ ( zero_zero @ A ) @ B )
         => ( ( ord_less @ A @ B @ ( one_one @ A ) )
           => ( ( ord_less_eq @ A @ ( power_power @ A @ B @ M ) @ ( power_power @ A @ B @ N ) )
              = ( ord_less_eq @ nat @ N @ M ) ) ) ) ) ).

% power_decreasing_iff
thf(fact_77_le__divide__eq__1__pos,axiom,
    ! [A: $tType] :
      ( ( linordered_field @ A )
     => ! [A2: A,B: A] :
          ( ( ord_less @ A @ ( zero_zero @ A ) @ A2 )
         => ( ( ord_less_eq @ A @ ( one_one @ A ) @ ( divide_divide @ A @ B @ A2 ) )
            = ( ord_less_eq @ A @ A2 @ B ) ) ) ) ).

% le_divide_eq_1_pos
thf(fact_78_le__divide__eq__1__neg,axiom,
    ! [A: $tType] :
      ( ( linordered_field @ A )
     => ! [A2: A,B: A] :
          ( ( ord_less @ A @ A2 @ ( zero_zero @ A ) )
         => ( ( ord_less_eq @ A @ ( one_one @ A ) @ ( divide_divide @ A @ B @ A2 ) )
            = ( ord_less_eq @ A @ B @ A2 ) ) ) ) ).

% le_divide_eq_1_neg
thf(fact_79_divide__le__eq__1__pos,axiom,
    ! [A: $tType] :
      ( ( linordered_field @ A )
     => ! [A2: A,B: A] :
          ( ( ord_less @ A @ ( zero_zero @ A ) @ A2 )
         => ( ( ord_less_eq @ A @ ( divide_divide @ A @ B @ A2 ) @ ( one_one @ A ) )
            = ( ord_less_eq @ A @ B @ A2 ) ) ) ) ).

% divide_le_eq_1_pos
thf(fact_80_divide__le__eq__1__neg,axiom,
    ! [A: $tType] :
      ( ( linordered_field @ A )
     => ! [A2: A,B: A] :
          ( ( ord_less @ A @ A2 @ ( zero_zero @ A ) )
         => ( ( ord_less_eq @ A @ ( divide_divide @ A @ B @ A2 ) @ ( one_one @ A ) )
            = ( ord_less_eq @ A @ A2 @ B ) ) ) ) ).

% divide_le_eq_1_neg
thf(fact_81__092_060open_062A_A_P_Areal__of__int_Ab_A_094_An_A_092_060le_062_AA_A_P_A1_092_060close_062,axiom,
    ord_less_eq @ real @ ( divide_divide @ real @ a @ ( power_power @ real @ ( ring_1_of_int @ real @ b ) @ n ) ) @ ( divide_divide @ real @ a @ ( one_one @ real ) ) ).

% \<open>A / real_of_int b ^ n \<le> A / 1\<close>
thf(fact_82_zero__less__power__abs__iff,axiom,
    ! [A: $tType] :
      ( ( linordered_idom @ A )
     => ! [A2: A,N: nat] :
          ( ( ord_less @ A @ ( zero_zero @ A ) @ ( power_power @ A @ ( abs_abs @ A @ A2 ) @ N ) )
          = ( ( A2
             != ( zero_zero @ A ) )
            | ( N
              = ( zero_zero @ nat ) ) ) ) ) ).

% zero_less_power_abs_iff
thf(fact_83_zero__le__divide__abs__iff,axiom,
    ! [A: $tType] :
      ( ( linordered_field @ A )
     => ! [A2: A,B: A] :
          ( ( ord_less_eq @ A @ ( zero_zero @ A ) @ ( divide_divide @ A @ A2 @ ( abs_abs @ A @ B ) ) )
          = ( ( ord_less_eq @ A @ ( zero_zero @ A ) @ A2 )
            | ( B
              = ( zero_zero @ A ) ) ) ) ) ).

% zero_le_divide_abs_iff
thf(fact_84_divide__le__0__abs__iff,axiom,
    ! [A: $tType] :
      ( ( linordered_field @ A )
     => ! [A2: A,B: A] :
          ( ( ord_less_eq @ A @ ( divide_divide @ A @ A2 @ ( abs_abs @ A @ B ) ) @ ( zero_zero @ A ) )
          = ( ( ord_less_eq @ A @ A2 @ ( zero_zero @ A ) )
            | ( B
              = ( zero_zero @ A ) ) ) ) ) ).

% divide_le_0_abs_iff
thf(fact_85_A__pos,axiom,
    ord_less @ real @ ( zero_zero @ real ) @ a ).

% A_pos
thf(fact_86_A__less_I1_J,axiom,
    ord_less @ real @ a @ ( one_one @ real ) ).

% A_less(1)
thf(fact_87__092_060open_062A_A_092_060le_062_A1_092_060close_062,axiom,
    ord_less_eq @ real @ a @ ( one_one @ real ) ).

% \<open>A \<le> 1\<close>
thf(fact_88_power__one__right,axiom,
    ! [A: $tType] :
      ( ( monoid_mult @ A )
     => ! [A2: A] :
          ( ( power_power @ A @ A2 @ ( one_one @ nat ) )
          = A2 ) ) ).

% power_one_right
thf(fact_89_nat__zero__less__power__iff,axiom,
    ! [X: nat,N: nat] :
      ( ( ord_less @ nat @ ( zero_zero @ nat ) @ ( power_power @ nat @ X @ N ) )
      = ( ( ord_less @ nat @ ( zero_zero @ nat ) @ X )
        | ( N
          = ( zero_zero @ nat ) ) ) ) ).

% nat_zero_less_power_iff
thf(fact_90_divide__eq__0__iff,axiom,
    ! [A: $tType] :
      ( ( field @ A )
     => ! [A2: A,B: A] :
          ( ( ( divide_divide @ A @ A2 @ B )
            = ( zero_zero @ A ) )
          = ( ( A2
              = ( zero_zero @ A ) )
            | ( B
              = ( zero_zero @ A ) ) ) ) ) ).

% divide_eq_0_iff
thf(fact_91_divide__cancel__left,axiom,
    ! [A: $tType] :
      ( ( field @ A )
     => ! [C: A,A2: A,B: A] :
          ( ( ( divide_divide @ A @ C @ A2 )
            = ( divide_divide @ A @ C @ B ) )
          = ( ( C
              = ( zero_zero @ A ) )
            | ( A2 = B ) ) ) ) ).

% divide_cancel_left
thf(fact_92_divide__cancel__right,axiom,
    ! [A: $tType] :
      ( ( field @ A )
     => ! [A2: A,C: A,B: A] :
          ( ( ( divide_divide @ A @ A2 @ C )
            = ( divide_divide @ A @ B @ C ) )
          = ( ( C
              = ( zero_zero @ A ) )
            | ( A2 = B ) ) ) ) ).

% divide_cancel_right
thf(fact_93_division__ring__divide__zero,axiom,
    ! [A: $tType] :
      ( ( division_ring @ A )
     => ! [A2: A] :
          ( ( divide_divide @ A @ A2 @ ( zero_zero @ A ) )
          = ( zero_zero @ A ) ) ) ).

% division_ring_divide_zero
thf(fact_94_power__one,axiom,
    ! [A: $tType] :
      ( ( monoid_mult @ A )
     => ! [N: nat] :
          ( ( power_power @ A @ ( one_one @ A ) @ N )
          = ( one_one @ A ) ) ) ).

% power_one
thf(fact_95_abs__divide,axiom,
    ! [A: $tType] :
      ( ( field_abs_sgn @ A )
     => ! [A2: A,B: A] :
          ( ( abs_abs @ A @ ( divide_divide @ A @ A2 @ B ) )
          = ( divide_divide @ A @ ( abs_abs @ A @ A2 ) @ ( abs_abs @ A @ B ) ) ) ) ).

% abs_divide
thf(fact_96_divide__eq__1__iff,axiom,
    ! [A: $tType] :
      ( ( field @ A )
     => ! [A2: A,B: A] :
          ( ( ( divide_divide @ A @ A2 @ B )
            = ( one_one @ A ) )
          = ( ( B
             != ( zero_zero @ A ) )
            & ( A2 = B ) ) ) ) ).

% divide_eq_1_iff
thf(fact_97_one__eq__divide__iff,axiom,
    ! [A: $tType] :
      ( ( field @ A )
     => ! [A2: A,B: A] :
          ( ( ( one_one @ A )
            = ( divide_divide @ A @ A2 @ B ) )
          = ( ( B
             != ( zero_zero @ A ) )
            & ( A2 = B ) ) ) ) ).

% one_eq_divide_iff
thf(fact_98_divide__self,axiom,
    ! [A: $tType] :
      ( ( division_ring @ A )
     => ! [A2: A] :
          ( ( A2
           != ( zero_zero @ A ) )
         => ( ( divide_divide @ A @ A2 @ A2 )
            = ( one_one @ A ) ) ) ) ).

% divide_self
thf(fact_99_divide__self__if,axiom,
    ! [A: $tType] :
      ( ( division_ring @ A )
     => ! [A2: A] :
          ( ( ( A2
              = ( zero_zero @ A ) )
           => ( ( divide_divide @ A @ A2 @ A2 )
              = ( zero_zero @ A ) ) )
          & ( ( A2
             != ( zero_zero @ A ) )
           => ( ( divide_divide @ A @ A2 @ A2 )
              = ( one_one @ A ) ) ) ) ) ).

% divide_self_if
thf(fact_100_divide__eq__eq__1,axiom,
    ! [A: $tType] :
      ( ( linordered_field @ A )
     => ! [B: A,A2: A] :
          ( ( ( divide_divide @ A @ B @ A2 )
            = ( one_one @ A ) )
          = ( ( A2
             != ( zero_zero @ A ) )
            & ( A2 = B ) ) ) ) ).

% divide_eq_eq_1
thf(fact_101_eq__divide__eq__1,axiom,
    ! [A: $tType] :
      ( ( linordered_field @ A )
     => ! [B: A,A2: A] :
          ( ( ( one_one @ A )
            = ( divide_divide @ A @ B @ A2 ) )
          = ( ( A2
             != ( zero_zero @ A ) )
            & ( A2 = B ) ) ) ) ).

% eq_divide_eq_1
thf(fact_102_one__divide__eq__0__iff,axiom,
    ! [A: $tType] :
      ( ( linordered_field @ A )
     => ! [A2: A] :
          ( ( ( divide_divide @ A @ ( one_one @ A ) @ A2 )
            = ( zero_zero @ A ) )
          = ( A2
            = ( zero_zero @ A ) ) ) ) ).

% one_divide_eq_0_iff
thf(fact_103_zero__eq__1__divide__iff,axiom,
    ! [A: $tType] :
      ( ( linordered_field @ A )
     => ! [A2: A] :
          ( ( ( zero_zero @ A )
            = ( divide_divide @ A @ ( one_one @ A ) @ A2 ) )
          = ( A2
            = ( zero_zero @ A ) ) ) ) ).

% zero_eq_1_divide_iff
thf(fact_104_power__inject__exp,axiom,
    ! [A: $tType] :
      ( ( linordered_semidom @ A )
     => ! [A2: A,M: nat,N: nat] :
          ( ( ord_less @ A @ ( one_one @ A ) @ A2 )
         => ( ( ( power_power @ A @ A2 @ M )
              = ( power_power @ A @ A2 @ N ) )
            = ( M = N ) ) ) ) ).

% power_inject_exp
thf(fact_105_power__strict__increasing__iff,axiom,
    ! [A: $tType] :
      ( ( linordered_semidom @ A )
     => ! [B: A,X: nat,Y2: nat] :
          ( ( ord_less @ A @ ( one_one @ A ) @ B )
         => ( ( ord_less @ A @ ( power_power @ A @ B @ X ) @ ( power_power @ A @ B @ Y2 ) )
            = ( ord_less @ nat @ X @ Y2 ) ) ) ) ).

% power_strict_increasing_iff
thf(fact_106_power__eq__0__iff,axiom,
    ! [A: $tType] :
      ( ( semiri134348788visors @ A )
     => ! [A2: A,N: nat] :
          ( ( ( power_power @ A @ A2 @ N )
            = ( zero_zero @ A ) )
          = ( ( A2
              = ( zero_zero @ A ) )
            & ( ord_less @ nat @ ( zero_zero @ nat ) @ N ) ) ) ) ).

% power_eq_0_iff
thf(fact_107_degree__0,axiom,
    ! [A: $tType] :
      ( ( zero @ A )
     => ( ( degree @ A @ ( zero_zero @ ( poly @ A ) ) )
        = ( zero_zero @ nat ) ) ) ).

% degree_0
thf(fact_108_degree__1,axiom,
    ! [A: $tType] :
      ( ( comm_semiring_1 @ A )
     => ( ( degree @ A @ ( one_one @ ( poly @ A ) ) )
        = ( zero_zero @ nat ) ) ) ).

% degree_1
thf(fact_109_degree__of__int,axiom,
    ! [A: $tType] :
      ( ( comm_ring_1 @ A )
     => ! [K: int] :
          ( ( degree @ A @ ( ring_1_of_int @ ( poly @ A ) @ K ) )
          = ( zero_zero @ nat ) ) ) ).

% degree_of_int
thf(fact_110_divide__le__0__1__iff,axiom,
    ! [A: $tType] :
      ( ( linordered_field @ A )
     => ! [A2: A] :
          ( ( ord_less_eq @ A @ ( divide_divide @ A @ ( one_one @ A ) @ A2 ) @ ( zero_zero @ A ) )
          = ( ord_less_eq @ A @ A2 @ ( zero_zero @ A ) ) ) ) ).

% divide_le_0_1_iff
thf(fact_111_zero__le__divide__1__iff,axiom,
    ! [A: $tType] :
      ( ( linordered_field @ A )
     => ! [A2: A] :
          ( ( ord_less_eq @ A @ ( zero_zero @ A ) @ ( divide_divide @ A @ ( one_one @ A ) @ A2 ) )
          = ( ord_less_eq @ A @ ( zero_zero @ A ) @ A2 ) ) ) ).

% zero_le_divide_1_iff
thf(fact_112_divide__less__0__1__iff,axiom,
    ! [A: $tType] :
      ( ( linordered_field @ A )
     => ! [A2: A] :
          ( ( ord_less @ A @ ( divide_divide @ A @ ( one_one @ A ) @ A2 ) @ ( zero_zero @ A ) )
          = ( ord_less @ A @ A2 @ ( zero_zero @ A ) ) ) ) ).

% divide_less_0_1_iff
thf(fact_113_divide__less__eq__1__neg,axiom,
    ! [A: $tType] :
      ( ( linordered_field @ A )
     => ! [A2: A,B: A] :
          ( ( ord_less @ A @ A2 @ ( zero_zero @ A ) )
         => ( ( ord_less @ A @ ( divide_divide @ A @ B @ A2 ) @ ( one_one @ A ) )
            = ( ord_less @ A @ A2 @ B ) ) ) ) ).

% divide_less_eq_1_neg
thf(fact_114_divide__less__eq__1__pos,axiom,
    ! [A: $tType] :
      ( ( linordered_field @ A )
     => ! [A2: A,B: A] :
          ( ( ord_less @ A @ ( zero_zero @ A ) @ A2 )
         => ( ( ord_less @ A @ ( divide_divide @ A @ B @ A2 ) @ ( one_one @ A ) )
            = ( ord_less @ A @ B @ A2 ) ) ) ) ).

% divide_less_eq_1_pos
thf(fact_115_less__divide__eq__1__neg,axiom,
    ! [A: $tType] :
      ( ( linordered_field @ A )
     => ! [A2: A,B: A] :
          ( ( ord_less @ A @ A2 @ ( zero_zero @ A ) )
         => ( ( ord_less @ A @ ( one_one @ A ) @ ( divide_divide @ A @ B @ A2 ) )
            = ( ord_less @ A @ B @ A2 ) ) ) ) ).

% less_divide_eq_1_neg
thf(fact_116_less__divide__eq__1__pos,axiom,
    ! [A: $tType] :
      ( ( linordered_field @ A )
     => ! [A2: A,B: A] :
          ( ( ord_less @ A @ ( zero_zero @ A ) @ A2 )
         => ( ( ord_less @ A @ ( one_one @ A ) @ ( divide_divide @ A @ B @ A2 ) )
            = ( ord_less @ A @ A2 @ B ) ) ) ) ).

% less_divide_eq_1_pos
thf(fact_117_zero__less__divide__1__iff,axiom,
    ! [A: $tType] :
      ( ( linordered_field @ A )
     => ! [A2: A] :
          ( ( ord_less @ A @ ( zero_zero @ A ) @ ( divide_divide @ A @ ( one_one @ A ) @ A2 ) )
          = ( ord_less @ A @ ( zero_zero @ A ) @ A2 ) ) ) ).

% zero_less_divide_1_iff
thf(fact_118_power__strict__decreasing__iff,axiom,
    ! [A: $tType] :
      ( ( linordered_semidom @ A )
     => ! [B: A,M: nat,N: nat] :
          ( ( ord_less @ A @ ( zero_zero @ A ) @ B )
         => ( ( ord_less @ A @ B @ ( one_one @ A ) )
           => ( ( ord_less @ A @ ( power_power @ A @ B @ M ) @ ( power_power @ A @ B @ N ) )
              = ( ord_less @ nat @ N @ M ) ) ) ) ) ).

% power_strict_decreasing_iff
thf(fact_119_power__mono__iff,axiom,
    ! [A: $tType] :
      ( ( linordered_semidom @ A )
     => ! [A2: A,B: A,N: nat] :
          ( ( ord_less_eq @ A @ ( zero_zero @ A ) @ A2 )
         => ( ( ord_less_eq @ A @ ( zero_zero @ A ) @ B )
           => ( ( ord_less @ nat @ ( zero_zero @ nat ) @ N )
             => ( ( ord_less_eq @ A @ ( power_power @ A @ A2 @ N ) @ ( power_power @ A @ B @ N ) )
                = ( ord_less_eq @ A @ A2 @ B ) ) ) ) ) ) ).

% power_mono_iff
thf(fact_120_power__increasing__iff,axiom,
    ! [A: $tType] :
      ( ( linordered_semidom @ A )
     => ! [B: A,X: nat,Y2: nat] :
          ( ( ord_less @ A @ ( one_one @ A ) @ B )
         => ( ( ord_less_eq @ A @ ( power_power @ A @ B @ X ) @ ( power_power @ A @ B @ Y2 ) )
            = ( ord_less_eq @ nat @ X @ Y2 ) ) ) ) ).

% power_increasing_iff
thf(fact_121__092_060open_062_092_060not_062_AA_A_P_Areal__of__int_Ab_A_094_An_A_060_A_092_060bar_062x_A_N_Areal__of__int_Aa_A_P_Areal__of__int_Ab_092_060bar_062_092_060close_062,axiom,
    ~ ( ord_less @ real @ ( divide_divide @ real @ a @ ( power_power @ real @ ( ring_1_of_int @ real @ b ) @ n ) ) @ ( abs_abs @ real @ ( minus_minus @ real @ x @ ( divide_divide @ real @ ( ring_1_of_int @ real @ a2 ) @ ( ring_1_of_int @ real @ b ) ) ) ) ) ).

% \<open>\<not> A / real_of_int b ^ n < \<bar>x - real_of_int a / real_of_int b\<bar>\<close>
thf(fact_122_nat__power__less__imp__less,axiom,
    ! [I: nat,M: nat,N: nat] :
      ( ( ord_less @ nat @ ( zero_zero @ nat ) @ I )
     => ( ( ord_less @ nat @ ( power_power @ nat @ I @ M ) @ ( power_power @ nat @ I @ N ) )
       => ( ord_less @ nat @ M @ N ) ) ) ).

% nat_power_less_imp_less
thf(fact_123_div__poly__less,axiom,
    ! [A: $tType] :
      ( ( field @ A )
     => ! [X: poly @ A,Y2: poly @ A] :
          ( ( ord_less @ nat @ ( degree @ A @ X ) @ ( degree @ A @ Y2 ) )
         => ( ( divide_divide @ ( poly @ A ) @ X @ Y2 )
            = ( zero_zero @ ( poly @ A ) ) ) ) ) ).

% div_poly_less
thf(fact_124_self__le__power,axiom,
    ! [A: $tType] :
      ( ( linordered_semidom @ A )
     => ! [A2: A,N: nat] :
          ( ( ord_less_eq @ A @ ( one_one @ A ) @ A2 )
         => ( ( ord_less @ nat @ ( zero_zero @ nat ) @ N )
           => ( ord_less_eq @ A @ A2 @ ( power_power @ A @ A2 @ N ) ) ) ) ) ).

% self_le_power
thf(fact_125_divide__poly__0,axiom,
    ! [A: $tType] :
      ( ( idom_divide @ A )
     => ! [F: poly @ A] :
          ( ( divide_divide @ ( poly @ A ) @ F @ ( zero_zero @ ( poly @ A ) ) )
          = ( zero_zero @ ( poly @ A ) ) ) ) ).

% divide_poly_0
thf(fact_126_zero__power,axiom,
    ! [A: $tType] :
      ( ( semiring_1 @ A )
     => ! [N: nat] :
          ( ( ord_less @ nat @ ( zero_zero @ nat ) @ N )
         => ( ( power_power @ A @ ( zero_zero @ A ) @ N )
            = ( zero_zero @ A ) ) ) ) ).

% zero_power
thf(fact_127_power__0,axiom,
    ! [A: $tType] :
      ( ( power @ A )
     => ! [A2: A] :
          ( ( power_power @ A @ A2 @ ( zero_zero @ nat ) )
          = ( one_one @ A ) ) ) ).

% power_0
thf(fact_128_power__eq__iff__eq__base,axiom,
    ! [A: $tType] :
      ( ( linordered_semidom @ A )
     => ! [N: nat,A2: A,B: A] :
          ( ( ord_less @ nat @ ( zero_zero @ nat ) @ N )
         => ( ( ord_less_eq @ A @ ( zero_zero @ A ) @ A2 )
           => ( ( ord_less_eq @ A @ ( zero_zero @ A ) @ B )
             => ( ( ( power_power @ A @ A2 @ N )
                  = ( power_power @ A @ B @ N ) )
                = ( A2 = B ) ) ) ) ) ) ).

% power_eq_iff_eq_base
thf(fact_129_power__eq__imp__eq__base,axiom,
    ! [A: $tType] :
      ( ( linordered_semidom @ A )
     => ! [A2: A,N: nat,B: A] :
          ( ( ( power_power @ A @ A2 @ N )
            = ( power_power @ A @ B @ N ) )
         => ( ( ord_less_eq @ A @ ( zero_zero @ A ) @ A2 )
           => ( ( ord_less_eq @ A @ ( zero_zero @ A ) @ B )
             => ( ( ord_less @ nat @ ( zero_zero @ nat ) @ N )
               => ( A2 = B ) ) ) ) ) ) ).

% power_eq_imp_eq_base
thf(fact_130_one__less__power,axiom,
    ! [A: $tType] :
      ( ( linordered_semidom @ A )
     => ! [A2: A,N: nat] :
          ( ( ord_less @ A @ ( one_one @ A ) @ A2 )
         => ( ( ord_less @ nat @ ( zero_zero @ nat ) @ N )
           => ( ord_less @ A @ ( one_one @ A ) @ ( power_power @ A @ A2 @ N ) ) ) ) ) ).

% one_less_power
thf(fact_131_poly__IVT__neg,axiom,
    ! [A2: real,B: real,P: poly @ real] :
      ( ( ord_less @ real @ A2 @ B )
     => ( ( ord_less @ real @ ( zero_zero @ real ) @ ( poly2 @ real @ P @ A2 ) )
       => ( ( ord_less @ real @ ( poly2 @ real @ P @ B ) @ ( zero_zero @ real ) )
         => ? [X3: real] :
              ( ( ord_less @ real @ A2 @ X3 )
              & ( ord_less @ real @ X3 @ B )
              & ( ( poly2 @ real @ P @ X3 )
                = ( zero_zero @ real ) ) ) ) ) ) ).

% poly_IVT_neg
thf(fact_132_poly__IVT__pos,axiom,
    ! [A2: real,B: real,P: poly @ real] :
      ( ( ord_less @ real @ A2 @ B )
     => ( ( ord_less @ real @ ( poly2 @ real @ P @ A2 ) @ ( zero_zero @ real ) )
       => ( ( ord_less @ real @ ( zero_zero @ real ) @ ( poly2 @ real @ P @ B ) )
         => ? [X3: real] :
              ( ( ord_less @ real @ A2 @ X3 )
              & ( ord_less @ real @ X3 @ B )
              & ( ( poly2 @ real @ P @ X3 )
                = ( zero_zero @ real ) ) ) ) ) ) ).

% poly_IVT_pos
thf(fact_133_linordered__field__no__ub,axiom,
    ! [A: $tType] :
      ( ( linordered_field @ A )
     => ! [X4: A] :
        ? [X_1: A] : ( ord_less @ A @ X4 @ X_1 ) ) ).

% linordered_field_no_ub
thf(fact_134_linordered__field__no__lb,axiom,
    ! [A: $tType] :
      ( ( linordered_field @ A )
     => ! [X4: A] :
        ? [Y3: A] : ( ord_less @ A @ Y3 @ X4 ) ) ).

% linordered_field_no_lb
thf(fact_135_coeff__eq__0,axiom,
    ! [A: $tType] :
      ( ( zero @ A )
     => ! [P: poly @ A,N: nat] :
          ( ( ord_less @ nat @ ( degree @ A @ P ) @ N )
         => ( ( coeff @ A @ P @ N )
            = ( zero_zero @ A ) ) ) ) ).

% coeff_eq_0
thf(fact_136_less__degree__imp,axiom,
    ! [A: $tType] :
      ( ( zero @ A )
     => ! [N: nat,P: poly @ A] :
          ( ( ord_less @ nat @ N @ ( degree @ A @ P ) )
         => ? [I4: nat] :
              ( ( ord_less @ nat @ N @ I4 )
              & ( ( coeff @ A @ P @ I4 )
               != ( zero_zero @ A ) ) ) ) ) ).

% less_degree_imp
thf(fact_137_degree__le,axiom,
    ! [A: $tType] :
      ( ( zero @ A )
     => ! [N: nat,P: poly @ A] :
          ( ! [I4: nat] :
              ( ( ord_less @ nat @ N @ I4 )
             => ( ( coeff @ A @ P @ I4 )
                = ( zero_zero @ A ) ) )
         => ( ord_less_eq @ nat @ ( degree @ A @ P ) @ N ) ) ) ).

% degree_le
thf(fact_138_Liouville__Numbers__Misc_ORats__cases_H,axiom,
    ! [X: real] :
      ( ( member @ real @ X @ ( field_char_0_Rats @ real ) )
     => ~ ! [P2: int,Q4: int] :
            ( ( ord_less @ int @ ( zero_zero @ int ) @ Q4 )
           => ( X
             != ( divide_divide @ real @ ( ring_1_of_int @ real @ P2 ) @ ( ring_1_of_int @ real @ Q4 ) ) ) ) ) ).

% Liouville_Numbers_Misc.Rats_cases'
thf(fact_139_coeff__0__power,axiom,
    ! [A: $tType] :
      ( ( comm_semiring_1 @ A )
     => ! [P: poly @ A,N: nat] :
          ( ( coeff @ A @ ( power_power @ ( poly @ A ) @ P @ N ) @ ( zero_zero @ nat ) )
          = ( power_power @ A @ ( coeff @ A @ P @ ( zero_zero @ nat ) ) @ N ) ) ) ).

% coeff_0_power
thf(fact_140_eq__zero__or__degree__less,axiom,
    ! [A: $tType] :
      ( ( zero @ A )
     => ! [P: poly @ A,N: nat] :
          ( ( ord_less_eq @ nat @ ( degree @ A @ P ) @ N )
         => ( ( ( coeff @ A @ P @ N )
              = ( zero_zero @ A ) )
           => ( ( P
                = ( zero_zero @ ( poly @ A ) ) )
              | ( ord_less @ nat @ ( degree @ A @ P ) @ N ) ) ) ) ) ).

% eq_zero_or_degree_less
thf(fact_141_power__not__zero,axiom,
    ! [A: $tType] :
      ( ( semiri134348788visors @ A )
     => ! [A2: A,N: nat] :
          ( ( A2
           != ( zero_zero @ A ) )
         => ( ( power_power @ A @ A2 @ N )
           != ( zero_zero @ A ) ) ) ) ).

% power_not_zero
thf(fact_142_power__divide,axiom,
    ! [A: $tType] :
      ( ( field @ A )
     => ! [A2: A,B: A,N: nat] :
          ( ( power_power @ A @ ( divide_divide @ A @ A2 @ B ) @ N )
          = ( divide_divide @ A @ ( power_power @ A @ A2 @ N ) @ ( power_power @ A @ B @ N ) ) ) ) ).

% power_divide
thf(fact_143_poly__pinfty__gt__lc,axiom,
    ! [P: poly @ real] :
      ( ( ord_less @ real @ ( zero_zero @ real ) @ ( coeff @ real @ P @ ( degree @ real @ P ) ) )
     => ? [N2: real] :
        ! [X4: real] :
          ( ( ord_less_eq @ real @ N2 @ X4 )
         => ( ord_less_eq @ real @ ( coeff @ real @ P @ ( degree @ real @ P ) ) @ ( poly2 @ real @ P @ X4 ) ) ) ) ).

% poly_pinfty_gt_lc
thf(fact_144_power__abs,axiom,
    ! [A: $tType] :
      ( ( linordered_idom @ A )
     => ! [A2: A,N: nat] :
          ( ( abs_abs @ A @ ( power_power @ A @ A2 @ N ) )
          = ( power_power @ A @ ( abs_abs @ A @ A2 ) @ N ) ) ) ).

% power_abs
thf(fact_145_algebraic__altdef,axiom,
    ! [B2: $tType] :
      ( ( field_char_0 @ B2 )
     => ( ( algebraic @ B2 )
        = ( ^ [X2: B2] :
            ? [P4: poly @ B2] :
              ( ! [I3: nat] : ( member @ B2 @ ( coeff @ B2 @ P4 @ I3 ) @ ( field_char_0_Rats @ B2 ) )
              & ( P4
               != ( zero_zero @ ( poly @ B2 ) ) )
              & ( ( poly2 @ B2 @ P4 @ X2 )
                = ( zero_zero @ B2 ) ) ) ) ) ) ).

% algebraic_altdef
thf(fact_146_divide__le__0__iff,axiom,
    ! [A: $tType] :
      ( ( linordered_field @ A )
     => ! [A2: A,B: A] :
          ( ( ord_less_eq @ A @ ( divide_divide @ A @ A2 @ B ) @ ( zero_zero @ A ) )
          = ( ( ( ord_less_eq @ A @ ( zero_zero @ A ) @ A2 )
              & ( ord_less_eq @ A @ B @ ( zero_zero @ A ) ) )
            | ( ( ord_less_eq @ A @ A2 @ ( zero_zero @ A ) )
              & ( ord_less_eq @ A @ ( zero_zero @ A ) @ B ) ) ) ) ) ).

% divide_le_0_iff
thf(fact_147_divide__right__mono,axiom,
    ! [A: $tType] :
      ( ( linordered_field @ A )
     => ! [A2: A,B: A,C: A] :
          ( ( ord_less_eq @ A @ A2 @ B )
         => ( ( ord_less_eq @ A @ ( zero_zero @ A ) @ C )
           => ( ord_less_eq @ A @ ( divide_divide @ A @ A2 @ C ) @ ( divide_divide @ A @ B @ C ) ) ) ) ) ).

% divide_right_mono
thf(fact_148_zero__le__divide__iff,axiom,
    ! [A: $tType] :
      ( ( linordered_field @ A )
     => ! [A2: A,B: A] :
          ( ( ord_less_eq @ A @ ( zero_zero @ A ) @ ( divide_divide @ A @ A2 @ B ) )
          = ( ( ( ord_less_eq @ A @ ( zero_zero @ A ) @ A2 )
              & ( ord_less_eq @ A @ ( zero_zero @ A ) @ B ) )
            | ( ( ord_less_eq @ A @ A2 @ ( zero_zero @ A ) )
              & ( ord_less_eq @ A @ B @ ( zero_zero @ A ) ) ) ) ) ) ).

% zero_le_divide_iff
thf(fact_149_divide__nonneg__nonneg,axiom,
    ! [A: $tType] :
      ( ( linordered_field @ A )
     => ! [X: A,Y2: A] :
          ( ( ord_less_eq @ A @ ( zero_zero @ A ) @ X )
         => ( ( ord_less_eq @ A @ ( zero_zero @ A ) @ Y2 )
           => ( ord_less_eq @ A @ ( zero_zero @ A ) @ ( divide_divide @ A @ X @ Y2 ) ) ) ) ) ).

% divide_nonneg_nonneg
thf(fact_150_divide__nonneg__nonpos,axiom,
    ! [A: $tType] :
      ( ( linordered_field @ A )
     => ! [X: A,Y2: A] :
          ( ( ord_less_eq @ A @ ( zero_zero @ A ) @ X )
         => ( ( ord_less_eq @ A @ Y2 @ ( zero_zero @ A ) )
           => ( ord_less_eq @ A @ ( divide_divide @ A @ X @ Y2 ) @ ( zero_zero @ A ) ) ) ) ) ).

% divide_nonneg_nonpos
thf(fact_151_divide__nonpos__nonneg,axiom,
    ! [A: $tType] :
      ( ( linordered_field @ A )
     => ! [X: A,Y2: A] :
          ( ( ord_less_eq @ A @ X @ ( zero_zero @ A ) )
         => ( ( ord_less_eq @ A @ ( zero_zero @ A ) @ Y2 )
           => ( ord_less_eq @ A @ ( divide_divide @ A @ X @ Y2 ) @ ( zero_zero @ A ) ) ) ) ) ).

% divide_nonpos_nonneg
thf(fact_152_divide__nonpos__nonpos,axiom,
    ! [A: $tType] :
      ( ( linordered_field @ A )
     => ! [X: A,Y2: A] :
          ( ( ord_less_eq @ A @ X @ ( zero_zero @ A ) )
         => ( ( ord_less_eq @ A @ Y2 @ ( zero_zero @ A ) )
           => ( ord_less_eq @ A @ ( zero_zero @ A ) @ ( divide_divide @ A @ X @ Y2 ) ) ) ) ) ).

% divide_nonpos_nonpos
thf(fact_153_divide__right__mono__neg,axiom,
    ! [A: $tType] :
      ( ( linordered_field @ A )
     => ! [A2: A,B: A,C: A] :
          ( ( ord_less_eq @ A @ A2 @ B )
         => ( ( ord_less_eq @ A @ C @ ( zero_zero @ A ) )
           => ( ord_less_eq @ A @ ( divide_divide @ A @ B @ C ) @ ( divide_divide @ A @ A2 @ C ) ) ) ) ) ).

% divide_right_mono_neg
thf(fact_154_power__mono,axiom,
    ! [A: $tType] :
      ( ( linordered_semidom @ A )
     => ! [A2: A,B: A,N: nat] :
          ( ( ord_less_eq @ A @ A2 @ B )
         => ( ( ord_less_eq @ A @ ( zero_zero @ A ) @ A2 )
           => ( ord_less_eq @ A @ ( power_power @ A @ A2 @ N ) @ ( power_power @ A @ B @ N ) ) ) ) ) ).

% power_mono
thf(fact_155_zero__le__power,axiom,
    ! [A: $tType] :
      ( ( linordered_semidom @ A )
     => ! [A2: A,N: nat] :
          ( ( ord_less_eq @ A @ ( zero_zero @ A ) @ A2 )
         => ( ord_less_eq @ A @ ( zero_zero @ A ) @ ( power_power @ A @ A2 @ N ) ) ) ) ).

% zero_le_power
thf(fact_156_divide__neg__neg,axiom,
    ! [A: $tType] :
      ( ( linordered_field @ A )
     => ! [X: A,Y2: A] :
          ( ( ord_less @ A @ X @ ( zero_zero @ A ) )
         => ( ( ord_less @ A @ Y2 @ ( zero_zero @ A ) )
           => ( ord_less @ A @ ( zero_zero @ A ) @ ( divide_divide @ A @ X @ Y2 ) ) ) ) ) ).

% divide_neg_neg
thf(fact_157_divide__neg__pos,axiom,
    ! [A: $tType] :
      ( ( linordered_field @ A )
     => ! [X: A,Y2: A] :
          ( ( ord_less @ A @ X @ ( zero_zero @ A ) )
         => ( ( ord_less @ A @ ( zero_zero @ A ) @ Y2 )
           => ( ord_less @ A @ ( divide_divide @ A @ X @ Y2 ) @ ( zero_zero @ A ) ) ) ) ) ).

% divide_neg_pos
thf(fact_158_divide__pos__neg,axiom,
    ! [A: $tType] :
      ( ( linordered_field @ A )
     => ! [X: A,Y2: A] :
          ( ( ord_less @ A @ ( zero_zero @ A ) @ X )
         => ( ( ord_less @ A @ Y2 @ ( zero_zero @ A ) )
           => ( ord_less @ A @ ( divide_divide @ A @ X @ Y2 ) @ ( zero_zero @ A ) ) ) ) ) ).

% divide_pos_neg
thf(fact_159_divide__pos__pos,axiom,
    ! [A: $tType] :
      ( ( linordered_field @ A )
     => ! [X: A,Y2: A] :
          ( ( ord_less @ A @ ( zero_zero @ A ) @ X )
         => ( ( ord_less @ A @ ( zero_zero @ A ) @ Y2 )
           => ( ord_less @ A @ ( zero_zero @ A ) @ ( divide_divide @ A @ X @ Y2 ) ) ) ) ) ).

% divide_pos_pos
thf(fact_160_divide__less__0__iff,axiom,
    ! [A: $tType] :
      ( ( linordered_field @ A )
     => ! [A2: A,B: A] :
          ( ( ord_less @ A @ ( divide_divide @ A @ A2 @ B ) @ ( zero_zero @ A ) )
          = ( ( ( ord_less @ A @ ( zero_zero @ A ) @ A2 )
              & ( ord_less @ A @ B @ ( zero_zero @ A ) ) )
            | ( ( ord_less @ A @ A2 @ ( zero_zero @ A ) )
              & ( ord_less @ A @ ( zero_zero @ A ) @ B ) ) ) ) ) ).

% divide_less_0_iff
thf(fact_161_divide__less__cancel,axiom,
    ! [A: $tType] :
      ( ( linordered_field @ A )
     => ! [A2: A,C: A,B: A] :
          ( ( ord_less @ A @ ( divide_divide @ A @ A2 @ C ) @ ( divide_divide @ A @ B @ C ) )
          = ( ( ( ord_less @ A @ ( zero_zero @ A ) @ C )
             => ( ord_less @ A @ A2 @ B ) )
            & ( ( ord_less @ A @ C @ ( zero_zero @ A ) )
             => ( ord_less @ A @ B @ A2 ) )
            & ( C
             != ( zero_zero @ A ) ) ) ) ) ).

% divide_less_cancel
thf(fact_162_zero__less__divide__iff,axiom,
    ! [A: $tType] :
      ( ( linordered_field @ A )
     => ! [A2: A,B: A] :
          ( ( ord_less @ A @ ( zero_zero @ A ) @ ( divide_divide @ A @ A2 @ B ) )
          = ( ( ( ord_less @ A @ ( zero_zero @ A ) @ A2 )
              & ( ord_less @ A @ ( zero_zero @ A ) @ B ) )
            | ( ( ord_less @ A @ A2 @ ( zero_zero @ A ) )
              & ( ord_less @ A @ B @ ( zero_zero @ A ) ) ) ) ) ) ).

% zero_less_divide_iff
thf(fact_163_divide__strict__right__mono,axiom,
    ! [A: $tType] :
      ( ( linordered_field @ A )
     => ! [A2: A,B: A,C: A] :
          ( ( ord_less @ A @ A2 @ B )
         => ( ( ord_less @ A @ ( zero_zero @ A ) @ C )
           => ( ord_less @ A @ ( divide_divide @ A @ A2 @ C ) @ ( divide_divide @ A @ B @ C ) ) ) ) ) ).

% divide_strict_right_mono
thf(fact_164_divide__strict__right__mono__neg,axiom,
    ! [A: $tType] :
      ( ( linordered_field @ A )
     => ! [B: A,A2: A,C: A] :
          ( ( ord_less @ A @ B @ A2 )
         => ( ( ord_less @ A @ C @ ( zero_zero @ A ) )
           => ( ord_less @ A @ ( divide_divide @ A @ A2 @ C ) @ ( divide_divide @ A @ B @ C ) ) ) ) ) ).

% divide_strict_right_mono_neg
thf(fact_165_zero__less__power,axiom,
    ! [A: $tType] :
      ( ( linordered_semidom @ A )
     => ! [A2: A,N: nat] :
          ( ( ord_less @ A @ ( zero_zero @ A ) @ A2 )
         => ( ord_less @ A @ ( zero_zero @ A ) @ ( power_power @ A @ A2 @ N ) ) ) ) ).

% zero_less_power
thf(fact_166_right__inverse__eq,axiom,
    ! [A: $tType] :
      ( ( division_ring @ A )
     => ! [B: A,A2: A] :
          ( ( B
           != ( zero_zero @ A ) )
         => ( ( ( divide_divide @ A @ A2 @ B )
              = ( one_one @ A ) )
            = ( A2 = B ) ) ) ) ).

% right_inverse_eq
thf(fact_167_power__0__left,axiom,
    ! [A: $tType] :
      ( ( semiring_1 @ A )
     => ! [N: nat] :
          ( ( ( N
              = ( zero_zero @ nat ) )
           => ( ( power_power @ A @ ( zero_zero @ A ) @ N )
              = ( one_one @ A ) ) )
          & ( ( N
             != ( zero_zero @ nat ) )
           => ( ( power_power @ A @ ( zero_zero @ A ) @ N )
              = ( zero_zero @ A ) ) ) ) ) ).

% power_0_left
thf(fact_168_one__le__power,axiom,
    ! [A: $tType] :
      ( ( linordered_semidom @ A )
     => ! [A2: A,N: nat] :
          ( ( ord_less_eq @ A @ ( one_one @ A ) @ A2 )
         => ( ord_less_eq @ A @ ( one_one @ A ) @ ( power_power @ A @ A2 @ N ) ) ) ) ).

% one_le_power
thf(fact_169_power__increasing,axiom,
    ! [A: $tType] :
      ( ( linordered_semidom @ A )
     => ! [N: nat,N4: nat,A2: A] :
          ( ( ord_less_eq @ nat @ N @ N4 )
         => ( ( ord_less_eq @ A @ ( one_one @ A ) @ A2 )
           => ( ord_less_eq @ A @ ( power_power @ A @ A2 @ N ) @ ( power_power @ A @ A2 @ N4 ) ) ) ) ) ).

% power_increasing
thf(fact_170_power__less__imp__less__exp,axiom,
    ! [A: $tType] :
      ( ( linordered_semidom @ A )
     => ! [A2: A,M: nat,N: nat] :
          ( ( ord_less @ A @ ( one_one @ A ) @ A2 )
         => ( ( ord_less @ A @ ( power_power @ A @ A2 @ M ) @ ( power_power @ A @ A2 @ N ) )
           => ( ord_less @ nat @ M @ N ) ) ) ) ).

% power_less_imp_less_exp
thf(fact_171_power__strict__increasing,axiom,
    ! [A: $tType] :
      ( ( linordered_semidom @ A )
     => ! [N: nat,N4: nat,A2: A] :
          ( ( ord_less @ nat @ N @ N4 )
         => ( ( ord_less @ A @ ( one_one @ A ) @ A2 )
           => ( ord_less @ A @ ( power_power @ A @ A2 @ N ) @ ( power_power @ A @ A2 @ N4 ) ) ) ) ) ).

% power_strict_increasing
thf(fact_172_power__one__over,axiom,
    ! [A: $tType] :
      ( ( division_ring @ A )
     => ! [A2: A,N: nat] :
          ( ( power_power @ A @ ( divide_divide @ A @ ( one_one @ A ) @ A2 ) @ N )
          = ( divide_divide @ A @ ( one_one @ A ) @ ( power_power @ A @ A2 @ N ) ) ) ) ).

% power_one_over
thf(fact_173_nonzero__abs__divide,axiom,
    ! [A: $tType] :
      ( ( linordered_field @ A )
     => ! [B: A,A2: A] :
          ( ( B
           != ( zero_zero @ A ) )
         => ( ( abs_abs @ A @ ( divide_divide @ A @ A2 @ B ) )
            = ( divide_divide @ A @ ( abs_abs @ A @ A2 ) @ ( abs_abs @ A @ B ) ) ) ) ) ).

% nonzero_abs_divide
thf(fact_174_frac__le,axiom,
    ! [A: $tType] :
      ( ( linordered_field @ A )
     => ! [Y2: A,X: A,W: A,Z: A] :
          ( ( ord_less_eq @ A @ ( zero_zero @ A ) @ Y2 )
         => ( ( ord_less_eq @ A @ X @ Y2 )
           => ( ( ord_less @ A @ ( zero_zero @ A ) @ W )
             => ( ( ord_less_eq @ A @ W @ Z )
               => ( ord_less_eq @ A @ ( divide_divide @ A @ X @ Z ) @ ( divide_divide @ A @ Y2 @ W ) ) ) ) ) ) ) ).

% frac_le
thf(fact_175_frac__less,axiom,
    ! [A: $tType] :
      ( ( linordered_field @ A )
     => ! [X: A,Y2: A,W: A,Z: A] :
          ( ( ord_less_eq @ A @ ( zero_zero @ A ) @ X )
         => ( ( ord_less @ A @ X @ Y2 )
           => ( ( ord_less @ A @ ( zero_zero @ A ) @ W )
             => ( ( ord_less_eq @ A @ W @ Z )
               => ( ord_less @ A @ ( divide_divide @ A @ X @ Z ) @ ( divide_divide @ A @ Y2 @ W ) ) ) ) ) ) ) ).

% frac_less
thf(fact_176_frac__less2,axiom,
    ! [A: $tType] :
      ( ( linordered_field @ A )
     => ! [X: A,Y2: A,W: A,Z: A] :
          ( ( ord_less @ A @ ( zero_zero @ A ) @ X )
         => ( ( ord_less_eq @ A @ X @ Y2 )
           => ( ( ord_less @ A @ ( zero_zero @ A ) @ W )
             => ( ( ord_less @ A @ W @ Z )
               => ( ord_less @ A @ ( divide_divide @ A @ X @ Z ) @ ( divide_divide @ A @ Y2 @ W ) ) ) ) ) ) ) ).

% frac_less2
thf(fact_177_divide__le__cancel,axiom,
    ! [A: $tType] :
      ( ( linordered_field @ A )
     => ! [A2: A,C: A,B: A] :
          ( ( ord_less_eq @ A @ ( divide_divide @ A @ A2 @ C ) @ ( divide_divide @ A @ B @ C ) )
          = ( ( ( ord_less @ A @ ( zero_zero @ A ) @ C )
             => ( ord_less_eq @ A @ A2 @ B ) )
            & ( ( ord_less @ A @ C @ ( zero_zero @ A ) )
             => ( ord_less_eq @ A @ B @ A2 ) ) ) ) ) ).

% divide_le_cancel
thf(fact_178_divide__nonneg__neg,axiom,
    ! [A: $tType] :
      ( ( linordered_field @ A )
     => ! [X: A,Y2: A] :
          ( ( ord_less_eq @ A @ ( zero_zero @ A ) @ X )
         => ( ( ord_less @ A @ Y2 @ ( zero_zero @ A ) )
           => ( ord_less_eq @ A @ ( divide_divide @ A @ X @ Y2 ) @ ( zero_zero @ A ) ) ) ) ) ).

% divide_nonneg_neg
thf(fact_179_divide__nonneg__pos,axiom,
    ! [A: $tType] :
      ( ( linordered_field @ A )
     => ! [X: A,Y2: A] :
          ( ( ord_less_eq @ A @ ( zero_zero @ A ) @ X )
         => ( ( ord_less @ A @ ( zero_zero @ A ) @ Y2 )
           => ( ord_less_eq @ A @ ( zero_zero @ A ) @ ( divide_divide @ A @ X @ Y2 ) ) ) ) ) ).

% divide_nonneg_pos
thf(fact_180_divide__nonpos__neg,axiom,
    ! [A: $tType] :
      ( ( linordered_field @ A )
     => ! [X: A,Y2: A] :
          ( ( ord_less_eq @ A @ X @ ( zero_zero @ A ) )
         => ( ( ord_less @ A @ Y2 @ ( zero_zero @ A ) )
           => ( ord_less_eq @ A @ ( zero_zero @ A ) @ ( divide_divide @ A @ X @ Y2 ) ) ) ) ) ).

% divide_nonpos_neg
thf(fact_181_divide__nonpos__pos,axiom,
    ! [A: $tType] :
      ( ( linordered_field @ A )
     => ! [X: A,Y2: A] :
          ( ( ord_less_eq @ A @ X @ ( zero_zero @ A ) )
         => ( ( ord_less @ A @ ( zero_zero @ A ) @ Y2 )
           => ( ord_less_eq @ A @ ( divide_divide @ A @ X @ Y2 ) @ ( zero_zero @ A ) ) ) ) ) ).

% divide_nonpos_pos
thf(fact_182_power__less__imp__less__base,axiom,
    ! [A: $tType] :
      ( ( linordered_semidom @ A )
     => ! [A2: A,N: nat,B: A] :
          ( ( ord_less @ A @ ( power_power @ A @ A2 @ N ) @ ( power_power @ A @ B @ N ) )
         => ( ( ord_less_eq @ A @ ( zero_zero @ A ) @ B )
           => ( ord_less @ A @ A2 @ B ) ) ) ) ).

% power_less_imp_less_base
thf(fact_183_power__strict__mono,axiom,
    ! [A: $tType] :
      ( ( linordered_semidom @ A )
     => ! [A2: A,B: A,N: nat] :
          ( ( ord_less @ A @ A2 @ B )
         => ( ( ord_less_eq @ A @ ( zero_zero @ A ) @ A2 )
           => ( ( ord_less @ nat @ ( zero_zero @ nat ) @ N )
             => ( ord_less @ A @ ( power_power @ A @ A2 @ N ) @ ( power_power @ A @ B @ N ) ) ) ) ) ) ).

% power_strict_mono
thf(fact_184_power__le__one,axiom,
    ! [A: $tType] :
      ( ( linordered_semidom @ A )
     => ! [A2: A,N: nat] :
          ( ( ord_less_eq @ A @ ( zero_zero @ A ) @ A2 )
         => ( ( ord_less_eq @ A @ A2 @ ( one_one @ A ) )
           => ( ord_less_eq @ A @ ( power_power @ A @ A2 @ N ) @ ( one_one @ A ) ) ) ) ) ).

% power_le_one
thf(fact_185_power__decreasing,axiom,
    ! [A: $tType] :
      ( ( linordered_semidom @ A )
     => ! [N: nat,N4: nat,A2: A] :
          ( ( ord_less_eq @ nat @ N @ N4 )
         => ( ( ord_less_eq @ A @ ( zero_zero @ A ) @ A2 )
           => ( ( ord_less_eq @ A @ A2 @ ( one_one @ A ) )
             => ( ord_less_eq @ A @ ( power_power @ A @ A2 @ N4 ) @ ( power_power @ A @ A2 @ N ) ) ) ) ) ) ).

% power_decreasing
thf(fact_186_divide__less__eq__1,axiom,
    ! [A: $tType] :
      ( ( linordered_field @ A )
     => ! [B: A,A2: A] :
          ( ( ord_less @ A @ ( divide_divide @ A @ B @ A2 ) @ ( one_one @ A ) )
          = ( ( ( ord_less @ A @ ( zero_zero @ A ) @ A2 )
              & ( ord_less @ A @ B @ A2 ) )
            | ( ( ord_less @ A @ A2 @ ( zero_zero @ A ) )
              & ( ord_less @ A @ A2 @ B ) )
            | ( A2
              = ( zero_zero @ A ) ) ) ) ) ).

% divide_less_eq_1
thf(fact_187_less__divide__eq__1,axiom,
    ! [A: $tType] :
      ( ( linordered_field @ A )
     => ! [B: A,A2: A] :
          ( ( ord_less @ A @ ( one_one @ A ) @ ( divide_divide @ A @ B @ A2 ) )
          = ( ( ( ord_less @ A @ ( zero_zero @ A ) @ A2 )
              & ( ord_less @ A @ A2 @ B ) )
            | ( ( ord_less @ A @ A2 @ ( zero_zero @ A ) )
              & ( ord_less @ A @ B @ A2 ) ) ) ) ) ).

% less_divide_eq_1
thf(fact_188_power__strict__decreasing,axiom,
    ! [A: $tType] :
      ( ( linordered_semidom @ A )
     => ! [N: nat,N4: nat,A2: A] :
          ( ( ord_less @ nat @ N @ N4 )
         => ( ( ord_less @ A @ ( zero_zero @ A ) @ A2 )
           => ( ( ord_less @ A @ A2 @ ( one_one @ A ) )
             => ( ord_less @ A @ ( power_power @ A @ A2 @ N4 ) @ ( power_power @ A @ A2 @ N ) ) ) ) ) ) ).

% power_strict_decreasing
thf(fact_189_power__le__imp__le__exp,axiom,
    ! [A: $tType] :
      ( ( linordered_semidom @ A )
     => ! [A2: A,M: nat,N: nat] :
          ( ( ord_less @ A @ ( one_one @ A ) @ A2 )
         => ( ( ord_less_eq @ A @ ( power_power @ A @ A2 @ M ) @ ( power_power @ A @ A2 @ N ) )
           => ( ord_less_eq @ nat @ M @ N ) ) ) ) ).

% power_le_imp_le_exp
thf(fact_190_zero__le__power__abs,axiom,
    ! [A: $tType] :
      ( ( linordered_idom @ A )
     => ! [A2: A,N: nat] : ( ord_less_eq @ A @ ( zero_zero @ A ) @ ( power_power @ A @ ( abs_abs @ A @ A2 ) @ N ) ) ) ).

% zero_le_power_abs
thf(fact_191_abs__div__pos,axiom,
    ! [A: $tType] :
      ( ( linordered_field @ A )
     => ! [Y2: A,X: A] :
          ( ( ord_less @ A @ ( zero_zero @ A ) @ Y2 )
         => ( ( divide_divide @ A @ ( abs_abs @ A @ X ) @ Y2 )
            = ( abs_abs @ A @ ( divide_divide @ A @ X @ Y2 ) ) ) ) ) ).

% abs_div_pos
thf(fact_192_divide__le__eq__1,axiom,
    ! [A: $tType] :
      ( ( linordered_field @ A )
     => ! [B: A,A2: A] :
          ( ( ord_less_eq @ A @ ( divide_divide @ A @ B @ A2 ) @ ( one_one @ A ) )
          = ( ( ( ord_less @ A @ ( zero_zero @ A ) @ A2 )
              & ( ord_less_eq @ A @ B @ A2 ) )
            | ( ( ord_less @ A @ A2 @ ( zero_zero @ A ) )
              & ( ord_less_eq @ A @ A2 @ B ) )
            | ( A2
              = ( zero_zero @ A ) ) ) ) ) ).

% divide_le_eq_1
thf(fact_193_le__divide__eq__1,axiom,
    ! [A: $tType] :
      ( ( linordered_field @ A )
     => ! [B: A,A2: A] :
          ( ( ord_less_eq @ A @ ( one_one @ A ) @ ( divide_divide @ A @ B @ A2 ) )
          = ( ( ( ord_less @ A @ ( zero_zero @ A ) @ A2 )
              & ( ord_less_eq @ A @ A2 @ B ) )
            | ( ( ord_less @ A @ A2 @ ( zero_zero @ A ) )
              & ( ord_less_eq @ A @ B @ A2 ) ) ) ) ) ).

% le_divide_eq_1
thf(fact_194_A__less_I2_J,axiom,
    ord_less @ real @ a @ ( divide_divide @ real @ ( one_one @ real ) @ m ) ).

% A_less(2)
thf(fact_195_ab,axiom,
    ord_less_eq @ real @ ( abs_abs @ real @ ( minus_minus @ real @ x @ ( divide_divide @ real @ ( ring_1_of_int @ real @ a2 ) @ ( ring_1_of_int @ real @ b ) ) ) ) @ ( divide_divide @ real @ a @ ( power_power @ real @ ( ring_1_of_int @ real @ b ) @ n ) ) ).

% ab
thf(fact_196_ab_H,axiom,
    ord_less_eq @ real @ ( abs_abs @ real @ ( minus_minus @ real @ x @ ( divide_divide @ real @ ( ring_1_of_int @ real @ a2 ) @ ( ring_1_of_int @ real @ b ) ) ) ) @ a ).

% ab'
thf(fact_197_div__pos__pos__trivial,axiom,
    ! [K: int,L: int] :
      ( ( ord_less_eq @ int @ ( zero_zero @ int ) @ K )
     => ( ( ord_less @ int @ K @ L )
       => ( ( divide_divide @ int @ K @ L )
          = ( zero_zero @ int ) ) ) ) ).

% div_pos_pos_trivial
thf(fact_198_div__neg__neg__trivial,axiom,
    ! [K: int,L: int] :
      ( ( ord_less_eq @ int @ K @ ( zero_zero @ int ) )
     => ( ( ord_less @ int @ L @ K )
       => ( ( divide_divide @ int @ K @ L )
          = ( zero_zero @ int ) ) ) ) ).

% div_neg_neg_trivial
thf(fact_199_zero__less__abs__iff,axiom,
    ! [A: $tType] :
      ( ( ordere142940540dd_abs @ A )
     => ! [A2: A] :
          ( ( ord_less @ A @ ( zero_zero @ A ) @ ( abs_abs @ A @ A2 ) )
          = ( A2
           != ( zero_zero @ A ) ) ) ) ).

% zero_less_abs_iff
thf(fact_200_M__pos,axiom,
    ord_less @ real @ ( zero_zero @ real ) @ m ).

% M_pos
thf(fact_201_abs__idempotent,axiom,
    ! [A: $tType] :
      ( ( ordere142940540dd_abs @ A )
     => ! [A2: A] :
          ( ( abs_abs @ A @ ( abs_abs @ A @ A2 ) )
          = ( abs_abs @ A @ A2 ) ) ) ).

% abs_idempotent
thf(fact_202_le__zero__eq,axiom,
    ! [A: $tType] :
      ( ( canoni770627133id_add @ A )
     => ! [N: A] :
          ( ( ord_less_eq @ A @ N @ ( zero_zero @ A ) )
          = ( N
            = ( zero_zero @ A ) ) ) ) ).

% le_zero_eq
thf(fact_203_not__gr__zero,axiom,
    ! [A: $tType] :
      ( ( canoni770627133id_add @ A )
     => ! [N: A] :
          ( ( ~ ( ord_less @ A @ ( zero_zero @ A ) @ N ) )
          = ( N
            = ( zero_zero @ A ) ) ) ) ).

% not_gr_zero
thf(fact_204_cancel__comm__monoid__add__class_Odiff__cancel,axiom,
    ! [A: $tType] :
      ( ( cancel1352612707id_add @ A )
     => ! [A2: A] :
          ( ( minus_minus @ A @ A2 @ A2 )
          = ( zero_zero @ A ) ) ) ).

% cancel_comm_monoid_add_class.diff_cancel
thf(fact_205_diff__zero,axiom,
    ! [A: $tType] :
      ( ( cancel1352612707id_add @ A )
     => ! [A2: A] :
          ( ( minus_minus @ A @ A2 @ ( zero_zero @ A ) )
          = A2 ) ) ).

% diff_zero
thf(fact_206_zero__diff,axiom,
    ! [A: $tType] :
      ( ( comm_monoid_diff @ A )
     => ! [A2: A] :
          ( ( minus_minus @ A @ ( zero_zero @ A ) @ A2 )
          = ( zero_zero @ A ) ) ) ).

% zero_diff
thf(fact_207_diff__0__right,axiom,
    ! [A: $tType] :
      ( ( group_add @ A )
     => ! [A2: A] :
          ( ( minus_minus @ A @ A2 @ ( zero_zero @ A ) )
          = A2 ) ) ).

% diff_0_right
thf(fact_208_diff__self,axiom,
    ! [A: $tType] :
      ( ( group_add @ A )
     => ! [A2: A] :
          ( ( minus_minus @ A @ A2 @ A2 )
          = ( zero_zero @ A ) ) ) ).

% diff_self
thf(fact_209_abs__zero,axiom,
    ! [A: $tType] :
      ( ( ordere142940540dd_abs @ A )
     => ( ( abs_abs @ A @ ( zero_zero @ A ) )
        = ( zero_zero @ A ) ) ) ).

% abs_zero
thf(fact_210_abs__eq__0,axiom,
    ! [A: $tType] :
      ( ( ordere142940540dd_abs @ A )
     => ! [A2: A] :
          ( ( ( abs_abs @ A @ A2 )
            = ( zero_zero @ A ) )
          = ( A2
            = ( zero_zero @ A ) ) ) ) ).

% abs_eq_0
thf(fact_211_abs__0__eq,axiom,
    ! [A: $tType] :
      ( ( ordere142940540dd_abs @ A )
     => ! [A2: A] :
          ( ( ( zero_zero @ A )
            = ( abs_abs @ A @ A2 ) )
          = ( A2
            = ( zero_zero @ A ) ) ) ) ).

% abs_0_eq
thf(fact_212_div__less,axiom,
    ! [M: nat,N: nat] :
      ( ( ord_less @ nat @ M @ N )
     => ( ( divide_divide @ nat @ M @ N )
        = ( zero_zero @ nat ) ) ) ).

% div_less
thf(fact_213_of__int__diff,axiom,
    ! [A: $tType] :
      ( ( ring_1 @ A )
     => ! [W: int,Z: int] :
          ( ( ring_1_of_int @ A @ ( minus_minus @ int @ W @ Z ) )
          = ( minus_minus @ A @ ( ring_1_of_int @ A @ W ) @ ( ring_1_of_int @ A @ Z ) ) ) ) ).

% of_int_diff
thf(fact_214_coeff__diff,axiom,
    ! [A: $tType] :
      ( ( cancel1352612707id_add @ A )
     => ! [P: poly @ A,Q: poly @ A,N: nat] :
          ( ( coeff @ A @ ( minus_minus @ ( poly @ A ) @ P @ Q ) @ N )
          = ( minus_minus @ A @ ( coeff @ A @ P @ N ) @ ( coeff @ A @ Q @ N ) ) ) ) ).

% coeff_diff
thf(fact_215_poly__diff,axiom,
    ! [A: $tType] :
      ( ( comm_ring @ A )
     => ! [P: poly @ A,Q: poly @ A,X: A] :
          ( ( poly2 @ A @ ( minus_minus @ ( poly @ A ) @ P @ Q ) @ X )
          = ( minus_minus @ A @ ( poly2 @ A @ P @ X ) @ ( poly2 @ A @ Q @ X ) ) ) ) ).

% poly_diff
thf(fact_216_A__less_I3_J,axiom,
    ! [X5: real] :
      ( ( X5 != x )
     => ( ( ( poly2 @ real @ p @ X5 )
          = ( zero_zero @ real ) )
       => ( ord_less @ real @ a @ ( abs_abs @ real @ ( minus_minus @ real @ X5 @ x ) ) ) ) ) ).

% A_less(3)
thf(fact_217_diff__ge__0__iff__ge,axiom,
    ! [A: $tType] :
      ( ( ordered_ab_group_add @ A )
     => ! [A2: A,B: A] :
          ( ( ord_less_eq @ A @ ( zero_zero @ A ) @ ( minus_minus @ A @ A2 @ B ) )
          = ( ord_less_eq @ A @ B @ A2 ) ) ) ).

% diff_ge_0_iff_ge
thf(fact_218_diff__gt__0__iff__gt,axiom,
    ! [A: $tType] :
      ( ( ordered_ab_group_add @ A )
     => ! [A2: A,B: A] :
          ( ( ord_less @ A @ ( zero_zero @ A ) @ ( minus_minus @ A @ A2 @ B ) )
          = ( ord_less @ A @ B @ A2 ) ) ) ).

% diff_gt_0_iff_gt
thf(fact_219_abs__le__zero__iff,axiom,
    ! [A: $tType] :
      ( ( ordere142940540dd_abs @ A )
     => ! [A2: A] :
          ( ( ord_less_eq @ A @ ( abs_abs @ A @ A2 ) @ ( zero_zero @ A ) )
          = ( A2
            = ( zero_zero @ A ) ) ) ) ).

% abs_le_zero_iff
thf(fact_220_abs__le__self__iff,axiom,
    ! [A: $tType] :
      ( ( ordere142940540dd_abs @ A )
     => ! [A2: A] :
          ( ( ord_less_eq @ A @ ( abs_abs @ A @ A2 ) @ A2 )
          = ( ord_less_eq @ A @ ( zero_zero @ A ) @ A2 ) ) ) ).

% abs_le_self_iff
thf(fact_221_abs__of__nonneg,axiom,
    ! [A: $tType] :
      ( ( ordere142940540dd_abs @ A )
     => ! [A2: A] :
          ( ( ord_less_eq @ A @ ( zero_zero @ A ) @ A2 )
         => ( ( abs_abs @ A @ A2 )
            = A2 ) ) ) ).

% abs_of_nonneg
thf(fact_222_that,axiom,
    ! [C: real,N: nat] :
      ( ( ord_less @ real @ ( zero_zero @ real ) @ C )
     => ( ! [P2: int,Q4: int] :
            ( ( ord_less @ int @ ( zero_zero @ int ) @ Q4 )
           => ( ord_less @ real @ ( divide_divide @ real @ C @ ( power_power @ real @ ( ring_1_of_int @ real @ Q4 ) @ N ) ) @ ( abs_abs @ real @ ( minus_minus @ real @ x @ ( divide_divide @ real @ ( ring_1_of_int @ real @ P2 ) @ ( ring_1_of_int @ real @ Q4 ) ) ) ) ) )
       => thesis ) ) ).

% that
thf(fact_223_minus__poly_Orep__eq,axiom,
    ! [A: $tType] :
      ( ( cancel1352612707id_add @ A )
     => ! [X: poly @ A,Xa: poly @ A] :
          ( ( coeff @ A @ ( minus_minus @ ( poly @ A ) @ X @ Xa ) )
          = ( ^ [N3: nat] : ( minus_minus @ A @ ( coeff @ A @ X @ N3 ) @ ( coeff @ A @ Xa @ N3 ) ) ) ) ) ).

% minus_poly.rep_eq
thf(fact_224_eq__iff__diff__eq__0,axiom,
    ! [A: $tType] :
      ( ( group_add @ A )
     => ( ( ^ [Y: A,Z2: A] : ( Y = Z2 ) )
        = ( ^ [A4: A,B3: A] :
              ( ( minus_minus @ A @ A4 @ B3 )
              = ( zero_zero @ A ) ) ) ) ) ).

% eq_iff_diff_eq_0
thf(fact_225_diff__mono,axiom,
    ! [A: $tType] :
      ( ( ordered_ab_group_add @ A )
     => ! [A2: A,B: A,D: A,C: A] :
          ( ( ord_less_eq @ A @ A2 @ B )
         => ( ( ord_less_eq @ A @ D @ C )
           => ( ord_less_eq @ A @ ( minus_minus @ A @ A2 @ C ) @ ( minus_minus @ A @ B @ D ) ) ) ) ) ).

% diff_mono
thf(fact_226_diff__left__mono,axiom,
    ! [A: $tType] :
      ( ( ordered_ab_group_add @ A )
     => ! [B: A,A2: A,C: A] :
          ( ( ord_less_eq @ A @ B @ A2 )
         => ( ord_less_eq @ A @ ( minus_minus @ A @ C @ A2 ) @ ( minus_minus @ A @ C @ B ) ) ) ) ).

% diff_left_mono
thf(fact_227_diff__right__mono,axiom,
    ! [A: $tType] :
      ( ( ordered_ab_group_add @ A )
     => ! [A2: A,B: A,C: A] :
          ( ( ord_less_eq @ A @ A2 @ B )
         => ( ord_less_eq @ A @ ( minus_minus @ A @ A2 @ C ) @ ( minus_minus @ A @ B @ C ) ) ) ) ).

% diff_right_mono
thf(fact_228_diff__eq__diff__less__eq,axiom,
    ! [A: $tType] :
      ( ( ordered_ab_group_add @ A )
     => ! [A2: A,B: A,C: A,D: A] :
          ( ( ( minus_minus @ A @ A2 @ B )
            = ( minus_minus @ A @ C @ D ) )
         => ( ( ord_less_eq @ A @ A2 @ B )
            = ( ord_less_eq @ A @ C @ D ) ) ) ) ).

% diff_eq_diff_less_eq
thf(fact_229_diff__strict__right__mono,axiom,
    ! [A: $tType] :
      ( ( ordered_ab_group_add @ A )
     => ! [A2: A,B: A,C: A] :
          ( ( ord_less @ A @ A2 @ B )
         => ( ord_less @ A @ ( minus_minus @ A @ A2 @ C ) @ ( minus_minus @ A @ B @ C ) ) ) ) ).

% diff_strict_right_mono
thf(fact_230_diff__strict__left__mono,axiom,
    ! [A: $tType] :
      ( ( ordered_ab_group_add @ A )
     => ! [B: A,A2: A,C: A] :
          ( ( ord_less @ A @ B @ A2 )
         => ( ord_less @ A @ ( minus_minus @ A @ C @ A2 ) @ ( minus_minus @ A @ C @ B ) ) ) ) ).

% diff_strict_left_mono
thf(fact_231_diff__eq__diff__less,axiom,
    ! [A: $tType] :
      ( ( ordered_ab_group_add @ A )
     => ! [A2: A,B: A,C: A,D: A] :
          ( ( ( minus_minus @ A @ A2 @ B )
            = ( minus_minus @ A @ C @ D ) )
         => ( ( ord_less @ A @ A2 @ B )
            = ( ord_less @ A @ C @ D ) ) ) ) ).

% diff_eq_diff_less
thf(fact_232_diff__strict__mono,axiom,
    ! [A: $tType] :
      ( ( ordered_ab_group_add @ A )
     => ! [A2: A,B: A,D: A,C: A] :
          ( ( ord_less @ A @ A2 @ B )
         => ( ( ord_less @ A @ D @ C )
           => ( ord_less @ A @ ( minus_minus @ A @ A2 @ C ) @ ( minus_minus @ A @ B @ D ) ) ) ) ) ).

% diff_strict_mono
thf(fact_233_abs__minus__commute,axiom,
    ! [A: $tType] :
      ( ( ordere142940540dd_abs @ A )
     => ! [A2: A,B: A] :
          ( ( abs_abs @ A @ ( minus_minus @ A @ A2 @ B ) )
          = ( abs_abs @ A @ ( minus_minus @ A @ B @ A2 ) ) ) ) ).

% abs_minus_commute
thf(fact_234_diff__eq__diff__eq,axiom,
    ! [A: $tType] :
      ( ( group_add @ A )
     => ! [A2: A,B: A,C: A,D: A] :
          ( ( ( minus_minus @ A @ A2 @ B )
            = ( minus_minus @ A @ C @ D ) )
         => ( ( A2 = B )
            = ( C = D ) ) ) ) ).

% diff_eq_diff_eq
thf(fact_235_cancel__ab__semigroup__add__class_Odiff__right__commute,axiom,
    ! [A: $tType] :
      ( ( cancel146912293up_add @ A )
     => ! [A2: A,C: A,B: A] :
          ( ( minus_minus @ A @ ( minus_minus @ A @ A2 @ C ) @ B )
          = ( minus_minus @ A @ ( minus_minus @ A @ A2 @ B ) @ C ) ) ) ).

% cancel_ab_semigroup_add_class.diff_right_commute
thf(fact_236_diff__divide__distrib,axiom,
    ! [A: $tType] :
      ( ( division_ring @ A )
     => ! [A2: A,B: A,C: A] :
          ( ( divide_divide @ A @ ( minus_minus @ A @ A2 @ B ) @ C )
          = ( minus_minus @ A @ ( divide_divide @ A @ A2 @ C ) @ ( divide_divide @ A @ B @ C ) ) ) ) ).

% diff_divide_distrib
thf(fact_237_le__iff__diff__le__0,axiom,
    ! [A: $tType] :
      ( ( ordered_ab_group_add @ A )
     => ( ( ord_less_eq @ A )
        = ( ^ [A4: A,B3: A] : ( ord_less_eq @ A @ ( minus_minus @ A @ A4 @ B3 ) @ ( zero_zero @ A ) ) ) ) ) ).

% le_iff_diff_le_0
thf(fact_238_less__iff__diff__less__0,axiom,
    ! [A: $tType] :
      ( ( ordered_ab_group_add @ A )
     => ( ( ord_less @ A )
        = ( ^ [A4: A,B3: A] : ( ord_less @ A @ ( minus_minus @ A @ A4 @ B3 ) @ ( zero_zero @ A ) ) ) ) ) ).

% less_iff_diff_less_0
thf(fact_239_Ints__diff,axiom,
    ! [A: $tType] :
      ( ( ring_1 @ A )
     => ! [A2: A,B: A] :
          ( ( member @ A @ A2 @ ( ring_1_Ints @ A ) )
         => ( ( member @ A @ B @ ( ring_1_Ints @ A ) )
           => ( member @ A @ ( minus_minus @ A @ A2 @ B ) @ ( ring_1_Ints @ A ) ) ) ) ) ).

% Ints_diff
thf(fact_240_abs__triangle__ineq2__sym,axiom,
    ! [A: $tType] :
      ( ( ordere142940540dd_abs @ A )
     => ! [A2: A,B: A] : ( ord_less_eq @ A @ ( minus_minus @ A @ ( abs_abs @ A @ A2 ) @ ( abs_abs @ A @ B ) ) @ ( abs_abs @ A @ ( minus_minus @ A @ B @ A2 ) ) ) ) ).

% abs_triangle_ineq2_sym
thf(fact_241_abs__triangle__ineq3,axiom,
    ! [A: $tType] :
      ( ( ordere142940540dd_abs @ A )
     => ! [A2: A,B: A] : ( ord_less_eq @ A @ ( abs_abs @ A @ ( minus_minus @ A @ ( abs_abs @ A @ A2 ) @ ( abs_abs @ A @ B ) ) ) @ ( abs_abs @ A @ ( minus_minus @ A @ A2 @ B ) ) ) ) ).

% abs_triangle_ineq3
thf(fact_242_abs__triangle__ineq2,axiom,
    ! [A: $tType] :
      ( ( ordere142940540dd_abs @ A )
     => ! [A2: A,B: A] : ( ord_less_eq @ A @ ( minus_minus @ A @ ( abs_abs @ A @ A2 ) @ ( abs_abs @ A @ B ) ) @ ( abs_abs @ A @ ( minus_minus @ A @ A2 @ B ) ) ) ) ).

% abs_triangle_ineq2
thf(fact_243_zero__reorient,axiom,
    ! [A: $tType] :
      ( ( zero @ A )
     => ! [X: A] :
          ( ( ( zero_zero @ A )
            = X )
          = ( X
            = ( zero_zero @ A ) ) ) ) ).

% zero_reorient
thf(fact_244_one__reorient,axiom,
    ! [A: $tType] :
      ( ( one @ A )
     => ! [X: A] :
          ( ( ( one_one @ A )
            = X )
          = ( X
            = ( one_one @ A ) ) ) ) ).

% one_reorient
thf(fact_245_div__eq__dividend__iff,axiom,
    ! [M: nat,N: nat] :
      ( ( ord_less @ nat @ ( zero_zero @ nat ) @ M )
     => ( ( ( divide_divide @ nat @ M @ N )
          = M )
        = ( N
          = ( one_one @ nat ) ) ) ) ).

% div_eq_dividend_iff
thf(fact_246_div__less__dividend,axiom,
    ! [N: nat,M: nat] :
      ( ( ord_less @ nat @ ( one_one @ nat ) @ N )
     => ( ( ord_less @ nat @ ( zero_zero @ nat ) @ M )
       => ( ord_less @ nat @ ( divide_divide @ nat @ M @ N ) @ M ) ) ) ).

% div_less_dividend
thf(fact_247_Euclidean__Division_Odiv__eq__0__iff,axiom,
    ! [M: nat,N: nat] :
      ( ( ( divide_divide @ nat @ M @ N )
        = ( zero_zero @ nat ) )
      = ( ( ord_less @ nat @ M @ N )
        | ( N
          = ( zero_zero @ nat ) ) ) ) ).

% Euclidean_Division.div_eq_0_iff
thf(fact_248_div__le__dividend,axiom,
    ! [M: nat,N: nat] : ( ord_less_eq @ nat @ ( divide_divide @ nat @ M @ N ) @ M ) ).

% div_le_dividend
thf(fact_249_div__le__mono,axiom,
    ! [M: nat,N: nat,K: nat] :
      ( ( ord_less_eq @ nat @ M @ N )
     => ( ord_less_eq @ nat @ ( divide_divide @ nat @ M @ K ) @ ( divide_divide @ nat @ N @ K ) ) ) ).

% div_le_mono
thf(fact_250_Ints__eq__abs__less1,axiom,
    ! [A: $tType] :
      ( ( linordered_idom @ A )
     => ! [X: A,Y2: A] :
          ( ( member @ A @ X @ ( ring_1_Ints @ A ) )
         => ( ( member @ A @ Y2 @ ( ring_1_Ints @ A ) )
           => ( ( X = Y2 )
              = ( ord_less @ A @ ( abs_abs @ A @ ( minus_minus @ A @ X @ Y2 ) ) @ ( one_one @ A ) ) ) ) ) ) ).

% Ints_eq_abs_less1
thf(fact_251_zero__le,axiom,
    ! [A: $tType] :
      ( ( canoni770627133id_add @ A )
     => ! [X: A] : ( ord_less_eq @ A @ ( zero_zero @ A ) @ X ) ) ).

% zero_le
thf(fact_252_gr__zeroI,axiom,
    ! [A: $tType] :
      ( ( canoni770627133id_add @ A )
     => ! [N: A] :
          ( ( N
           != ( zero_zero @ A ) )
         => ( ord_less @ A @ ( zero_zero @ A ) @ N ) ) ) ).

% gr_zeroI
thf(fact_253_not__less__zero,axiom,
    ! [A: $tType] :
      ( ( canoni770627133id_add @ A )
     => ! [N: A] :
          ~ ( ord_less @ A @ N @ ( zero_zero @ A ) ) ) ).

% not_less_zero

% Type constructors (91)
thf(tcon_Polynomial_Opoly___Rings_Oidom,axiom,
    ! [A5: $tType] :
      ( ( idom @ A5 )
     => ( idom @ ( poly @ A5 ) ) ) ).

thf(tcon_Polynomial_Opoly___Groups_Oab__group__add,axiom,
    ! [A5: $tType] :
      ( ( ab_group_add @ A5 )
     => ( ab_group_add @ ( poly @ A5 ) ) ) ).

thf(tcon_Real_Oreal___Rings_Oidom_1,axiom,
    idom @ real ).

thf(tcon_Real_Oreal___Groups_Oab__group__add_2,axiom,
    ab_group_add @ real ).

thf(tcon_Int_Oint___Rings_Oidom_3,axiom,
    idom @ int ).

thf(tcon_Int_Oint___Groups_Oab__group__add_4,axiom,
    ab_group_add @ int ).

thf(tcon_Int_Oint___Rings_Osemiring__1__no__zero__divisors,axiom,
    semiri134348788visors @ int ).

thf(tcon_Int_Oint___Rings_Osemiring__no__zero__divisors,axiom,
    semiri1193490041visors @ int ).

thf(tcon_Int_Oint___Groups_Oordered__ab__group__add__abs,axiom,
    ordere142940540dd_abs @ int ).

thf(tcon_Int_Oint___Groups_Ocancel__ab__semigroup__add,axiom,
    cancel146912293up_add @ int ).

thf(tcon_Int_Oint___Groups_Ocancel__comm__monoid__add,axiom,
    cancel1352612707id_add @ int ).

thf(tcon_Int_Oint___Rings_Oring__no__zero__divisors,axiom,
    ring_n68954251visors @ int ).

thf(tcon_Int_Oint___Groups_Oordered__ab__group__add,axiom,
    ordered_ab_group_add @ int ).

thf(tcon_Int_Oint___Rings_Olinordered__semidom,axiom,
    linordered_semidom @ int ).

thf(tcon_Int_Oint___Rings_Olinordered__idom,axiom,
    linordered_idom @ int ).

thf(tcon_Int_Oint___Rings_Ocomm__semiring__1,axiom,
    comm_semiring_1 @ int ).

thf(tcon_Int_Oint___Rings_Ocomm__semiring__0,axiom,
    comm_semiring_0 @ int ).

thf(tcon_Int_Oint___Groups_Omonoid__mult,axiom,
    monoid_mult @ int ).

thf(tcon_Int_Oint___Rings_Oidom__divide,axiom,
    idom_divide @ int ).

thf(tcon_Int_Oint___Rings_Ocomm__ring__1,axiom,
    comm_ring_1 @ int ).

thf(tcon_Int_Oint___Rings_Osemiring__1,axiom,
    semiring_1 @ int ).

thf(tcon_Int_Oint___Groups_Ogroup__add,axiom,
    group_add @ int ).

thf(tcon_Int_Oint___Rings_Ocomm__ring,axiom,
    comm_ring @ int ).

thf(tcon_Int_Oint___Nat_Oring__char__0,axiom,
    ring_char_0 @ int ).

thf(tcon_Int_Oint___Rings_Oring__1,axiom,
    ring_1 @ int ).

thf(tcon_Int_Oint___Power_Opower,axiom,
    power @ int ).

thf(tcon_Int_Oint___Groups_Ozero,axiom,
    zero @ int ).

thf(tcon_Int_Oint___Groups_Oone,axiom,
    one @ int ).

thf(tcon_Nat_Onat___Groups_Ocanonically__ordered__monoid__add,axiom,
    canoni770627133id_add @ nat ).

thf(tcon_Nat_Onat___Rings_Osemiring__1__no__zero__divisors_5,axiom,
    semiri134348788visors @ nat ).

thf(tcon_Nat_Onat___Rings_Osemiring__no__zero__divisors_6,axiom,
    semiri1193490041visors @ nat ).

thf(tcon_Nat_Onat___Groups_Ocancel__ab__semigroup__add_7,axiom,
    cancel146912293up_add @ nat ).

thf(tcon_Nat_Onat___Groups_Ocancel__comm__monoid__add_8,axiom,
    cancel1352612707id_add @ nat ).

thf(tcon_Nat_Onat___Rings_Olinordered__semidom_9,axiom,
    linordered_semidom @ nat ).

thf(tcon_Nat_Onat___Groups_Ocomm__monoid__diff,axiom,
    comm_monoid_diff @ nat ).

thf(tcon_Nat_Onat___Rings_Ocomm__semiring__1_10,axiom,
    comm_semiring_1 @ nat ).

thf(tcon_Nat_Onat___Rings_Ocomm__semiring__0_11,axiom,
    comm_semiring_0 @ nat ).

thf(tcon_Nat_Onat___Groups_Omonoid__mult_12,axiom,
    monoid_mult @ nat ).

thf(tcon_Nat_Onat___Rings_Osemiring__1_13,axiom,
    semiring_1 @ nat ).

thf(tcon_Nat_Onat___Power_Opower_14,axiom,
    power @ nat ).

thf(tcon_Nat_Onat___Groups_Ozero_15,axiom,
    zero @ nat ).

thf(tcon_Nat_Onat___Groups_Oone_16,axiom,
    one @ nat ).

thf(tcon_Real_Oreal___Rings_Osemiring__1__no__zero__divisors_17,axiom,
    semiri134348788visors @ real ).

thf(tcon_Real_Oreal___Rings_Osemiring__no__zero__divisors_18,axiom,
    semiri1193490041visors @ real ).

thf(tcon_Real_Oreal___Groups_Oordered__ab__group__add__abs_19,axiom,
    ordere142940540dd_abs @ real ).

thf(tcon_Real_Oreal___Groups_Ocancel__ab__semigroup__add_20,axiom,
    cancel146912293up_add @ real ).

thf(tcon_Real_Oreal___Groups_Ocancel__comm__monoid__add_21,axiom,
    cancel1352612707id_add @ real ).

thf(tcon_Real_Oreal___Rings_Oring__no__zero__divisors_22,axiom,
    ring_n68954251visors @ real ).

thf(tcon_Real_Oreal___Groups_Oordered__ab__group__add_23,axiom,
    ordered_ab_group_add @ real ).

thf(tcon_Real_Oreal___Rings_Olinordered__semidom_24,axiom,
    linordered_semidom @ real ).

thf(tcon_Real_Oreal___Fields_Olinordered__field,axiom,
    linordered_field @ real ).

thf(tcon_Real_Oreal___Rings_Olinordered__idom_25,axiom,
    linordered_idom @ real ).

thf(tcon_Real_Oreal___Rings_Ocomm__semiring__1_26,axiom,
    comm_semiring_1 @ real ).

thf(tcon_Real_Oreal___Rings_Ocomm__semiring__0_27,axiom,
    comm_semiring_0 @ real ).

thf(tcon_Real_Oreal___Fields_Ofield__abs__sgn,axiom,
    field_abs_sgn @ real ).

thf(tcon_Real_Oreal___Fields_Odivision__ring,axiom,
    division_ring @ real ).

thf(tcon_Real_Oreal___Fields_Ofield__char__0,axiom,
    field_char_0 @ real ).

thf(tcon_Real_Oreal___Groups_Omonoid__mult_28,axiom,
    monoid_mult @ real ).

thf(tcon_Real_Oreal___Rings_Oidom__divide_29,axiom,
    idom_divide @ real ).

thf(tcon_Real_Oreal___Rings_Ocomm__ring__1_30,axiom,
    comm_ring_1 @ real ).

thf(tcon_Real_Oreal___Rings_Osemiring__1_31,axiom,
    semiring_1 @ real ).

thf(tcon_Real_Oreal___Groups_Ogroup__add_32,axiom,
    group_add @ real ).

thf(tcon_Real_Oreal___Rings_Ocomm__ring_33,axiom,
    comm_ring @ real ).

thf(tcon_Real_Oreal___Nat_Oring__char__0_34,axiom,
    ring_char_0 @ real ).

thf(tcon_Real_Oreal___Rings_Oring__1_35,axiom,
    ring_1 @ real ).

thf(tcon_Real_Oreal___Fields_Ofield,axiom,
    field @ real ).

thf(tcon_Real_Oreal___Power_Opower_36,axiom,
    power @ real ).

thf(tcon_Real_Oreal___Groups_Ozero_37,axiom,
    zero @ real ).

thf(tcon_Real_Oreal___Groups_Oone_38,axiom,
    one @ real ).

thf(tcon_Polynomial_Opoly___Rings_Osemiring__1__no__zero__divisors_39,axiom,
    ! [A5: $tType] :
      ( ( ( comm_semiring_1 @ A5 )
        & ( semiri134348788visors @ A5 ) )
     => ( semiri134348788visors @ ( poly @ A5 ) ) ) ).

thf(tcon_Polynomial_Opoly___Rings_Osemiring__no__zero__divisors_40,axiom,
    ! [A5: $tType] :
      ( ( ( comm_semiring_0 @ A5 )
        & ( semiri1193490041visors @ A5 ) )
     => ( semiri1193490041visors @ ( poly @ A5 ) ) ) ).

thf(tcon_Polynomial_Opoly___Groups_Oordered__ab__group__add__abs_41,axiom,
    ! [A5: $tType] :
      ( ( linordered_idom @ A5 )
     => ( ordere142940540dd_abs @ ( poly @ A5 ) ) ) ).

thf(tcon_Polynomial_Opoly___Groups_Ocancel__ab__semigroup__add_42,axiom,
    ! [A5: $tType] :
      ( ( cancel1352612707id_add @ A5 )
     => ( cancel146912293up_add @ ( poly @ A5 ) ) ) ).

thf(tcon_Polynomial_Opoly___Groups_Ocancel__comm__monoid__add_43,axiom,
    ! [A5: $tType] :
      ( ( cancel1352612707id_add @ A5 )
     => ( cancel1352612707id_add @ ( poly @ A5 ) ) ) ).

thf(tcon_Polynomial_Opoly___Rings_Oring__no__zero__divisors_44,axiom,
    ! [A5: $tType] :
      ( ( idom @ A5 )
     => ( ring_n68954251visors @ ( poly @ A5 ) ) ) ).

thf(tcon_Polynomial_Opoly___Groups_Oordered__ab__group__add_45,axiom,
    ! [A5: $tType] :
      ( ( linordered_idom @ A5 )
     => ( ordered_ab_group_add @ ( poly @ A5 ) ) ) ).

thf(tcon_Polynomial_Opoly___Rings_Olinordered__semidom_46,axiom,
    ! [A5: $tType] :
      ( ( linordered_idom @ A5 )
     => ( linordered_semidom @ ( poly @ A5 ) ) ) ).

thf(tcon_Polynomial_Opoly___Rings_Olinordered__idom_47,axiom,
    ! [A5: $tType] :
      ( ( linordered_idom @ A5 )
     => ( linordered_idom @ ( poly @ A5 ) ) ) ).

thf(tcon_Polynomial_Opoly___Rings_Ocomm__semiring__1_48,axiom,
    ! [A5: $tType] :
      ( ( comm_semiring_1 @ A5 )
     => ( comm_semiring_1 @ ( poly @ A5 ) ) ) ).

thf(tcon_Polynomial_Opoly___Rings_Ocomm__semiring__0_49,axiom,
    ! [A5: $tType] :
      ( ( comm_semiring_0 @ A5 )
     => ( comm_semiring_0 @ ( poly @ A5 ) ) ) ).

thf(tcon_Polynomial_Opoly___Groups_Omonoid__mult_50,axiom,
    ! [A5: $tType] :
      ( ( comm_semiring_1 @ A5 )
     => ( monoid_mult @ ( poly @ A5 ) ) ) ).

thf(tcon_Polynomial_Opoly___Rings_Oidom__divide_51,axiom,
    ! [A5: $tType] :
      ( ( idom_divide @ A5 )
     => ( idom_divide @ ( poly @ A5 ) ) ) ).

thf(tcon_Polynomial_Opoly___Rings_Ocomm__ring__1_52,axiom,
    ! [A5: $tType] :
      ( ( comm_ring_1 @ A5 )
     => ( comm_ring_1 @ ( poly @ A5 ) ) ) ).

thf(tcon_Polynomial_Opoly___Rings_Osemiring__1_53,axiom,
    ! [A5: $tType] :
      ( ( comm_semiring_1 @ A5 )
     => ( semiring_1 @ ( poly @ A5 ) ) ) ).

thf(tcon_Polynomial_Opoly___Groups_Ogroup__add_54,axiom,
    ! [A5: $tType] :
      ( ( ab_group_add @ A5 )
     => ( group_add @ ( poly @ A5 ) ) ) ).

thf(tcon_Polynomial_Opoly___Rings_Ocomm__ring_55,axiom,
    ! [A5: $tType] :
      ( ( comm_ring @ A5 )
     => ( comm_ring @ ( poly @ A5 ) ) ) ).

thf(tcon_Polynomial_Opoly___Nat_Oring__char__0_56,axiom,
    ! [A5: $tType] :
      ( ( ( ring_char_0 @ A5 )
        & ( comm_ring_1 @ A5 ) )
     => ( ring_char_0 @ ( poly @ A5 ) ) ) ).

thf(tcon_Polynomial_Opoly___Rings_Oring__1_57,axiom,
    ! [A5: $tType] :
      ( ( comm_ring_1 @ A5 )
     => ( ring_1 @ ( poly @ A5 ) ) ) ).

thf(tcon_Polynomial_Opoly___Power_Opower_58,axiom,
    ! [A5: $tType] :
      ( ( comm_semiring_1 @ A5 )
     => ( power @ ( poly @ A5 ) ) ) ).

thf(tcon_Polynomial_Opoly___Groups_Ozero_59,axiom,
    ! [A5: $tType] :
      ( ( zero @ A5 )
     => ( zero @ ( poly @ A5 ) ) ) ).

thf(tcon_Polynomial_Opoly___Groups_Oone_60,axiom,
    ! [A5: $tType] :
      ( ( comm_semiring_1 @ A5 )
     => ( one @ ( poly @ A5 ) ) ) ).

% Conjectures (1)
thf(conj_0,conjecture,
    ord_less_eq @ real @ ( divide_divide @ real @ ( one_one @ real ) @ ( power_power @ real @ ( ring_1_of_int @ real @ b ) @ ( degree @ real @ p ) ) ) @ ( abs_abs @ real @ ( poly2 @ real @ p @ ( divide_divide @ real @ ( ring_1_of_int @ real @ a2 ) @ ( ring_1_of_int @ real @ b ) ) ) ) ).

%------------------------------------------------------------------------------
